/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.budget;

import com.meniga.sdk.helpers.Objects;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class RecurringPattern {
    private final int months;
    @Nonnull
    private final DateTime starting;
    @Nonnull
    private final DateTime until;

    private RecurringPattern(int months, @Nonnull DateTime starting, @Nonnull DateTime until) {
        this.months = months;
        this.starting = Objects.requireNonNull(starting);
        this.until = Objects.requireNonNull(until);
    }

    public static Builder everyMonths(int months) {
        return new Builder(months);
    }

    public int getMonths() {
        return this.months;
    }

    @Nonnull
    public DateTime getStarting() {
        return this.starting.withTimeAtStartOfDay().withDayOfMonth(1);
    }

    @Nonnull
    public DateTime getEndDate() {
        return this.getStarting().plusMonths(1).minusMillis(1);
    }

    @Nonnull
    public DateTime getUntil() {
        return this.until;
    }

    public static class Builder {
        private final int months;
        private DateTime starting;

        public Builder(int months) {
            this.months = months;
        }

        public Builder starting(@Nonnull DateTime starting) {
            this.starting = Objects.requireNonNull(starting);
            return this;
        }

        public RecurringPattern until(@Nonnull DateTime until) {
            return new RecurringPattern(this.months, this.starting, until);
        }

        public RecurringPattern withoutEndDate() {
            return new RecurringPattern(this.months, this.starting, DateTime.now().plusYears(16).withTimeAtStartOfDay());
        }
    }
}

