/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.budget;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.budget.BudgetEntryUpdate;
import com.meniga.sdk.models.budget.BudgetEntryUpdateExtensions;
import com.meniga.sdk.models.budget.BudgetRulesUpdate;
import com.meniga.sdk.models.budget.BudgetRulesUpdateExtensions;
import com.meniga.sdk.models.budget.CreateBudgetEntryExtensions;
import com.meniga.sdk.models.budget.FetchBudgetEntriesFilter;
import com.meniga.sdk.models.budget.FetchBudgetEntriesFilterExtensions;
import com.meniga.sdk.models.budget.MenigaBudgetRule;
import com.meniga.sdk.models.budget.NewBudgetEntry;
import com.meniga.sdk.models.budget.enums.GenerationType;
import com.meniga.sdk.models.budget.enums.GenerationTypeValue;
import com.meniga.sdk.models.budget.operators.MenigaBudgetOperations;
import com.meniga.sdk.models.categories.MenigaCategory;
import com.meniga.sdk.webservices.budget.GetBudgetEntryById;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.joda.time.DateTime;

public class MenigaBudgetEntry
implements Parcelable,
Serializable {
    protected static MenigaBudgetOperations apiOperator;
    protected long id;
    protected MenigaDecimal targetAmount;
    protected DateTime startDate;
    protected DateTime endDate;
    protected DateTime updatedAt;
    protected long budgetId;
    protected int generationType;
    protected MenigaDecimal spentAmount;
    protected List<Long> categoryIds;
    public static final Parcelable.Creator<MenigaBudgetEntry> CREATOR;

    protected MenigaBudgetEntry() {
    }

    public static void setOperator(MenigaBudgetOperations operator) {
        apiOperator = operator;
    }

    public long getId() {
        return this.id;
    }

    public MenigaDecimal getTargetAmount() {
        return this.targetAmount == null ? MenigaDecimal.ZERO : this.targetAmount;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public long getBudgetId() {
        return this.budgetId;
    }

    public GenerationTypeValue getGenerationType() {
        return new GenerationTypeValue(this.generationType);
    }

    public MenigaDecimal getSpentAmount() {
        return this.spentAmount;
    }

    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaBudgetEntry that = (MenigaBudgetEntry)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.budgetId != that.budgetId) {
            return false;
        }
        if (this.generationType != that.generationType) {
            return false;
        }
        if (this.targetAmount != null ? !this.targetAmount.equals(that.targetAmount) : that.targetAmount != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals((Object)that.startDate) : that.startDate != null) {
            return false;
        }
        if (this.endDate != null ? !this.endDate.equals((Object)that.endDate) : that.endDate != null) {
            return false;
        }
        if (this.updatedAt != null ? !this.updatedAt.equals((Object)that.updatedAt) : that.updatedAt != null) {
            return false;
        }
        if (this.spentAmount != null ? !this.spentAmount.equals(that.spentAmount) : that.spentAmount != null) {
            return false;
        }
        return this.categoryIds != null ? this.categoryIds.equals(that.categoryIds) : that.categoryIds == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.targetAmount != null ? this.targetAmount.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
        result = 31 * result + (int)(this.budgetId ^ this.budgetId >>> 32);
        result = 31 * result + this.generationType;
        result = 31 * result + (this.spentAmount != null ? this.spentAmount.hashCode() : 0);
        result = 31 * result + (this.categoryIds != null ? this.categoryIds.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeSerializable((Serializable)this.targetAmount);
        dest.writeSerializable((Serializable)this.startDate);
        dest.writeSerializable((Serializable)this.endDate);
        dest.writeSerializable((Serializable)this.updatedAt);
        dest.writeLong(this.budgetId);
        dest.writeInt(this.generationType);
        dest.writeSerializable((Serializable)this.spentAmount);
        dest.writeList(this.categoryIds);
    }

    protected MenigaBudgetEntry(Parcel in) {
        this.id = in.readLong();
        this.targetAmount = (MenigaDecimal)in.readSerializable();
        this.startDate = (DateTime)in.readSerializable();
        this.endDate = (DateTime)in.readSerializable();
        this.updatedAt = (DateTime)in.readSerializable();
        this.budgetId = in.readLong();
        this.generationType = in.readInt();
        this.spentAmount = (MenigaDecimal)in.readSerializable();
        this.categoryIds = new ArrayList<Long>();
        in.readList(this.categoryIds, Long.class.getClassLoader());
    }

    public String toString() {
        if (this.categoryIds.size() > 0) {
            return this.categoryIds.get(0) + ": " + this.startDate.toString("dd.MM.YYYY") + " - " + this.endDate.toString("dd.MM.YYYY");
        }
        return super.toString();
    }

    public static Result<List<MenigaBudgetEntry>> fetch(long budgetId) {
        return MenigaBudgetEntry.fetch(budgetId, DateTime.now().withDayOfMonth(1).withTimeAtStartOfDay(), DateTime.now().withDayOfMonth(1).withTimeAtStartOfDay().plusMonths(1).minusDays(1));
    }

    public static Result<List<MenigaBudgetEntry>> fetch(long budgetId, DateTime month) {
        return MenigaBudgetEntry.fetch(budgetId, month.withDayOfMonth(1).withTimeAtStartOfDay(), month.withDayOfMonth(1).withTimeAtStartOfDay().plusMonths(1).minusDays(1));
    }

    public static Result<List<MenigaBudgetEntry>> fetch(long budgetId, DateTime from, DateTime to) {
        return MenigaBudgetEntry.fetch(budgetId, from, to, null);
    }

    public static Result<List<MenigaBudgetEntry>> fetch(long budgetId, DateTime from, DateTime to, List<Long> categoryIds) {
        FetchBudgetEntriesFilter filter = new FetchBudgetEntriesFilter(budgetId);
        filter.setStartDate(from);
        filter.setEndDate(to);
        filter.setCategoryIds(categoryIds);
        filter.setAllowOverlappingEntries(true);
        return MenigaBudgetEntry.fetch(filter);
    }

    public static Result<List<MenigaBudgetEntry>> fetch(FetchBudgetEntriesFilter filter) {
        return apiOperator.getBudgetEntries(FetchBudgetEntriesFilterExtensions.toGetBudgetEntries(filter));
    }

    public static Result<MenigaBudgetEntry> fetch(long budgetId, long entryId) {
        return apiOperator.getBudgetEntry(new GetBudgetEntryById(budgetId, entryId));
    }

    @Deprecated
    public static Result<Void> update(long budgetId, MenigaDecimal targetAmount, DateTime startDate, DateTime endDate, MenigaCategory category, GenerationType generationType, int generationValue, DateTime wasNotUsed) {
        GenerationTypeValue generationTypeValue = new GenerationTypeValue(generationValue);
        generationTypeValue.setType(generationType);
        BudgetRulesUpdate parameters = new BudgetRulesUpdate(startDate, category.getId());
        parameters.setTargetAmount(targetAmount);
        parameters.setEndDate(endDate);
        parameters.setGenerationTypeValue(generationTypeValue);
        return MenigaBudgetEntry.update(budgetId, parameters);
    }

    @Deprecated
    public static Result<Void> update(long budgetId, BudgetRulesUpdate parameters) {
        return apiOperator.createBudgetRules(budgetId, BudgetRulesUpdateExtensions.toUpdateBudgetRules(parameters)).map(new Function1<List<MenigaBudgetRule>, Void>(){

            public Void invoke(List<MenigaBudgetRule> menigaBudgetRules) {
                return null;
            }
        });
    }

    public static Result<List<MenigaBudgetEntry>> create(long budgetId, NewBudgetEntry parameters) {
        return apiOperator.createBudgetEntries(budgetId, CreateBudgetEntryExtensions.toCreateBudgetEntries(parameters));
    }

    public Result<MenigaBudgetEntry> update(BudgetEntryUpdate parameters) {
        return apiOperator.updateBudgetEntry(this.budgetId, this.id, BudgetEntryUpdateExtensions.toUpdateBudgetEntry(parameters));
    }

    public Result<Void> delete() {
        return apiOperator.deleteBudgetEntry(this.budgetId, this.id);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaBudgetEntry>(){

            public MenigaBudgetEntry createFromParcel(Parcel source) {
                return new MenigaBudgetEntry(source);
            }

            public MenigaBudgetEntry[] newArray(int size) {
                return new MenigaBudgetEntry[size];
            }
        };
    }
}

