/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.converters;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.meniga.sdk.ErrorHandler;
import com.meniga.sdk.annotations.MetaProperty;
import com.meniga.sdk.converters.MenigaApiResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import retrofit2.Converter;

public abstract class MenigaConverter
extends Converter.Factory {
    protected String convertStreamToString(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            sb.append("\n");
        }
        catch (IOException ex) {
            ErrorHandler.reportAndHandle(ex);
            throw ex;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                ErrorHandler.reportAndHandle(ex);
            }
        }
        return sb.toString();
    }

    public static JsonArray getAsArray(InputStream stream) throws IOException {
        JsonObject jsonObject = MenigaConverter.readJsonObject(stream);
        return jsonObject.getAsJsonArray("data");
    }

    public static JsonArray getAsArray(JsonElement element) {
        JsonObject jobject = element.getAsJsonObject();
        return jobject.getAsJsonArray("data");
    }

    public static JsonObject getAsObject(InputStream stream) throws IOException {
        JsonElement jelement;
        try (InputStreamReader isr = new InputStreamReader(stream);){
            jelement = new JsonParser().parse((Reader)isr);
        }
        JsonObject jobject = jelement.getAsJsonObject();
        return jobject.getAsJsonObject("data");
    }

    public static MenigaApiResponse.Object getAsObjectApiResponse(InputStream stream) throws IOException {
        JsonObject jsonObject = MenigaConverter.readJsonObject(stream);
        return new MenigaApiResponse.Object(jsonObject.getAsJsonObject("data"), jsonObject.getAsJsonObject("meta"), jsonObject.getAsJsonObject("included"));
    }

    public static MenigaApiResponse.Array getAsArrayApiResponse(InputStream stream) throws IOException {
        JsonObject jsonObject = MenigaConverter.readJsonObject(stream);
        return new MenigaApiResponse.Array(jsonObject.getAsJsonArray("data"), jsonObject.getAsJsonObject("meta"), jsonObject.getAsJsonObject("included"));
    }

    private static JsonObject readJsonObject(InputStream stream) {
        InputStreamReader reader = new InputStreamReader(stream);
        JsonElement jsonElement = new JsonParser().parse((Reader)reader);
        return jsonElement.getAsJsonObject();
    }

    public static <T> T mergeMeta(@Nonnull Gson gson2, @Nonnull T dest, @Nonnull JsonObject meta) throws JsonSyntaxException {
        Field[] fields;
        Class<?> cl = dest.getClass();
        for (Field field : fields = cl.getDeclaredFields()) {
            String jsonProperty;
            if (!field.isAnnotationPresent(MetaProperty.class)) continue;
            String name = field.getName();
            MetaProperty metaProperty = field.getAnnotation(MetaProperty.class);
            String string = jsonProperty = metaProperty.fromProperty().length() > 0 ? metaProperty.fromProperty() : name;
            if (!meta.has(jsonProperty)) continue;
            boolean isAccessible = field.isAccessible();
            if (!isAccessible) {
                field.setAccessible(true);
            }
            try {
                Object data = gson2.fromJson(meta.get(jsonProperty), field.getType());
                field.set(dest, data);
            }
            catch (IllegalAccessException e) {
                throw new JsonSyntaxException("Failed to merge response json meta property \"" + jsonProperty + "\" into: " + dest.getClass().getCanonicalName() + " and it's field " + name, (Throwable)e);
            }
            if (isAccessible) continue;
            field.setAccessible(false);
        }
        return dest;
    }

    public static <T> String metaAsString(T target) {
        String s = "[";
        for (Field f : target.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(MetaProperty.class)) continue;
            try {
                f.setAccessible(true);
                s = s + f.getName() + "=" + f.get(target) + ",";
                f.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                s = s + f.getName() + "= inaccessible,";
            }
        }
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        return s + "]";
    }
}

