/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk;

import com.meniga.sdk.CustomErrorHandler;
import com.meniga.sdk.SpecialServiceEndpointDefinition;
import com.meniga.sdk.adapters.TaskAdapter;
import com.meniga.sdk.eventconverters.EventBaseConverter;
import com.meniga.sdk.eventconverters.generic.MenigaAccountAvailableAmountEventConverter;
import com.meniga.sdk.eventconverters.generic.MenigaChallengeEventConverter;
import com.meniga.sdk.eventconverters.generic.MenigaCustomEventConverter;
import com.meniga.sdk.eventconverters.generic.MenigaDialogEventConverter;
import com.meniga.sdk.eventconverters.generic.MenigaTransactionCountEventConverter;
import com.meniga.sdk.eventconverters.generic.MenigaTransactionEventConverter;
import com.meniga.sdk.interfaces.PersistenceMode;
import com.meniga.sdk.interfaces.PersistenceProvider;
import com.meniga.sdk.models.feed.MenigaFeedItem;
import com.meniga.sdk.providers.BasicTaskAdapter;
import com.meniga.sdk.webservices.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.CertificatePinner;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;

public class MenigaSettings {
    private static final long DEFAULT_TIMEOUT_IN_SECONDS = 60L;
    private final HttpUrl endpoint;
    private final Authenticator authenticator;
    private final long timeoutInSeconds;
    private final PersistenceMode persistenceMode;
    private PersistenceProvider persistenceProvider;
    private final Map<Service, SpecialServiceEndpointDefinition> specialServiceEndpoints;
    private final List<Interceptor> interceptors;
    private final List<Interceptor> networkInterceptors;
    private final CertificatePinner certificatePinner;
    private final List<EventBaseConverter> userEventFeedConverters;
    private final CustomErrorHandler errorHandler;
    private final TaskAdapter taskAdapter;
    private String culture;
    private SSLSocketFactory sslSocketFactory;
    private X509TrustManager x509TrustManager;

    private MenigaSettings(Builder builder) {
        this.endpoint = builder.endpoint;
        this.timeoutInSeconds = builder.timeoutInSeconds <= 0L ? 60L : builder.timeoutInSeconds;
        this.authenticator = builder.authenticator;
        this.persistenceProvider = builder.persistenceProvider;
        this.persistenceMode = builder.persistenceMode;
        this.specialServiceEndpoints = builder.specialServiceEndpoints;
        this.interceptors = builder.interceptors;
        this.userEventFeedConverters = builder.userEventFeedConverters;
        this.taskAdapter = builder.taskAdapter;
        this.errorHandler = builder.errorHandler;
        this.networkInterceptors = builder.networkInterceptors;
        this.certificatePinner = builder.certificatePinner;
        this.culture = builder.culture;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.x509TrustManager = builder.x509TrustManager;
    }

    public String getCulture() {
        return this.culture;
    }

    public void updateCulture(String culture) {
        this.culture = culture;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public HttpUrl getEndpoint() {
        return this.endpoint;
    }

    public X509TrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public CustomErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Map<Service, SpecialServiceEndpointDefinition> getSpecialServiceEndpoints() {
        return this.specialServiceEndpoints;
    }

    public long getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public List<Interceptor> getHttpInterceptors() {
        return this.interceptors;
    }

    public List<Interceptor> getNetworkInterceptors() {
        return this.networkInterceptors;
    }

    @Nullable
    public CertificatePinner getCertificatePinner() {
        return this.certificatePinner;
    }

    public List<EventBaseConverter> getUserEventFeedConverters() {
        return this.userEventFeedConverters;
    }

    public TaskAdapter getTaskAdapter() {
        return this.taskAdapter;
    }

    public static class Builder {
        private HttpUrl endpoint;
        private Authenticator authenticator;
        private PersistenceMode persistenceMode;
        private long timeoutInSeconds;
        private PersistenceProvider persistenceProvider;
        private Map<Service, SpecialServiceEndpointDefinition> specialServiceEndpoints = new HashMap<Service, SpecialServiceEndpointDefinition>();
        private List<Interceptor> interceptors = new ArrayList<Interceptor>();
        private List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
        private CertificatePinner certificatePinner;
        private final List<EventBaseConverter> userEventFeedConverters = new ArrayList<EventBaseConverter>();
        private CustomErrorHandler errorHandler;
        private TaskAdapter taskAdapter;
        private String culture = "en-GB";
        private SSLSocketFactory sslSocketFactory;
        private X509TrustManager x509TrustManager;

        public Builder endpoint(HttpUrl endpoint) {
            this.endpoint = endpoint;
            if (!endpoint.toString().endsWith("/")) {
                this.endpoint = HttpUrl.parse((String)(endpoint.toString() + "/"));
            }
            return this;
        }

        public Builder endpoint(String endpoint) {
            if (!endpoint.endsWith("/")) {
                endpoint = endpoint + "/";
            }
            this.endpoint = HttpUrl.parse((String)endpoint);
            return this;
        }

        public Builder authenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public Builder errorHandler(CustomErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        @Deprecated
        public Builder persistanceProvider(PersistenceProvider persistenceProvider) {
            return this.persistenceProvider(persistenceProvider);
        }

        public Builder persistenceProvider(@Nullable PersistenceProvider persistenceProvider) {
            this.persistenceProvider = persistenceProvider;
            return this;
        }

        public Builder persistenceMode(PersistenceMode persistenceMode) {
            this.persistenceMode = persistenceMode;
            return this;
        }

        public Builder timeout(long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public Builder addEndpointForService(Service service, String endpoint) {
            return this.addEndpointForServiceWithTimeout(service, endpoint, 0);
        }

        public Builder addEndpointForServiceWithTimeout(Service service, String endpoint, int timeoutInSeconds) {
            if (this.specialServiceEndpoints == null) {
                this.specialServiceEndpoints = new HashMap<Service, SpecialServiceEndpointDefinition>();
            }
            if (!endpoint.endsWith("/")) {
                endpoint = endpoint + "/";
            }
            this.specialServiceEndpoints.put(service, new SpecialServiceEndpointDefinition(endpoint, timeoutInSeconds));
            return this;
        }

        public Builder addHttpInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder addNetworkInterceptor(Interceptor interceptor) {
            this.networkInterceptors.add(interceptor);
            return this;
        }

        public Builder certificatePinner(@Nullable CertificatePinner certificatePinner) {
            this.certificatePinner = certificatePinner;
            return this;
        }

        public Builder useTaskAdapter(TaskAdapter taskAdapter) {
            this.taskAdapter = taskAdapter;
            return this;
        }

        public Builder useSSLFactory(SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.x509TrustManager = x509TrustManager;
            return this;
        }

        public Builder culture(String culture) {
            this.culture = culture;
            return this;
        }

        public Builder addUserEventFeedConverter(EventBaseConverter<MenigaFeedItem> converter) {
            this.userEventFeedConverters.add(converter);
            return this;
        }

        public MenigaSettings build() {
            if (this.taskAdapter == null) {
                this.taskAdapter = new BasicTaskAdapter();
            }
            this.preBuild();
            return new MenigaSettings(this);
        }

        private void preBuild() {
            this.userEventFeedConverters.add(new MenigaTransactionEventConverter());
            this.userEventFeedConverters.add(new MenigaAccountAvailableAmountEventConverter());
            this.userEventFeedConverters.add(new MenigaCustomEventConverter());
            this.userEventFeedConverters.add(new MenigaTransactionCountEventConverter());
            this.userEventFeedConverters.add(new MenigaDialogEventConverter());
            this.userEventFeedConverters.add(new MenigaChallengeEventConverter());
        }
    }
}

