package com.melo.android.mvp.ui

import android.content.Context
import android.os.Bundle
import android.support.v4.app.Fragment
import com.melo.android.mvp.business.MVPPresenter

abstract class MVPFragment<VIEW : MVPView, PRESENTER : MVPPresenter<VIEW>> : Fragment() {

    lateinit var presenter: PRESENTER

    protected abstract fun createPresenter(): PRESENTER

    override fun onAttach(context: Context?) {
        super.onAttach(context)
        presenter = createPresenter()
    }

    @Suppress("UNCHECKED_CAST")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        presenter.handler.init(this as VIEW)
    }

    @Suppress("UNCHECKED_CAST")
    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        presenter.handler.setView(this as VIEW)
    }

    override fun onStart() {
        super.onStart()
        presenter.onStart()
    }

    override fun onStop() {
        presenter.onStop()
        super.onStop()
    }

    override fun onDestroyView() {
        presenter.handler.setView(null)
        super.onDestroyView()
    }
}
