package com.melo.android.mvp.business;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ProxyHandler implements InvocationHandler {

    final MVPHandler mvpHandler;

    public ProxyHandler(MVPHandler mvpHandler) {
        this.mvpHandler = mvpHandler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {

        if (mvpHandler.getOriginal() != null) {
            return method.invoke(mvpHandler.getOriginal(), args);
        }

        return null;
    }
}
