package com.melo.android.mvp.business

import android.util.Log
import com.melo.android.mvp.ui.MVPView
import java.lang.reflect.Proxy

private const val TAG = "MVPHandler"
class MVPHandler<V: MVPView> {

    private val proxyHandler = ProxyHandler(this)
    var original: V? = null
    private lateinit var proxy: V

    @Suppress("UNCHECKED_CAST")
    fun init(original: V) {
        this.original = original

        val iView = getViewClazz()

        proxy = Proxy.newProxyInstance(iView.classLoader,
                arrayOf(iView),
                proxyHandler) as V
    }

    private fun getViewClazz(): Class<*> {

        for (clazz in this.original!!::class.java.interfaces) {
            if (MVPView::class.java.isAssignableFrom(clazz)) return clazz
        }

        throw UnsupportedOperationException("MVPView interface not found in view")
    }

    @Synchronized
    fun getView(): V {
        return proxy
//        if (proxy != null) return proxy
//
//        Log.e(TAG, "there are some problems because is returning the original view")
//
//        return original!!
    }

    @Synchronized
    fun setView(view: V?) {
        Log.d(TAG, "setting original view as $view")
        original = view
    }
}
