package com.melo.android.mvp.ui.loading;

import android.view.MotionEvent;
import android.view.View;

import com.melo.android.mvp.R;
import com.melo.android.mvp.ui.loading.event.EBToogleLoading;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class Loading {

    private View main;
    private int mainLayoutId;

    public Loading(View view) {
        this(view, R.id.lyt_loading_main);
    }

    public Loading(View view, int mainLayoutId) {
        this.mainLayoutId = mainLayoutId;
        bind(view);
    }

    private void bind(View view) {
        main = view.findViewById(mainLayoutId);
        addListeners();
    }

    private void addListeners() {
        main.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
    }

    public void show() {
        main.setVisibility(View.VISIBLE);
        main.bringToFront();
    }

    public void hide() {
        main.setVisibility(View.GONE);
    }

    //FIXME VERIFICAR SE NAO VAI JOGAR MULTIPLAS MENSAGENS (Talvez tagear para mostrar somente uma vez)
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(EBToogleLoading event) {
        if (event.isShow()) {
            show();
            return;
        }

        hide();
    }

    public void register() {
        EventBus.getDefault().register(this);
    }

    public void unregister() {
        EventBus.getDefault().unregister(this);
    }

}
