/*
 * Decompiled with CFR 0.152.
 */
package com.melo.android.mvp.business;

import android.util.Log;
import com.melo.android.mvp.business.IPresenter;
import com.melo.android.mvp.ui.fragment.IView;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class Presenter<V extends IView>
implements IPresenter<V> {
    private V original;
    private V proxy;
    private final Handler handler;

    public Presenter(V original) {
        this.original = original;
        this.handler = new Handler();
        Class iView = this.getIView();
        this.proxy = (IView)Proxy.newProxyInstance(iView.getClassLoader(), new Class[]{iView}, (InvocationHandler)this.handler);
    }

    private Class getIView() {
        Class<?>[] interfaces;
        for (Class<?> clazz : interfaces = this.original.getClass().getInterfaces()) {
            if (!IView.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        throw new UnsupportedOperationException("Interce IView not found in fragment");
    }

    @Override
    public synchronized void setView(V view) {
        Log.w((String)this.getClass().getName(), (String)("setting original view as " + view));
        this.original = view;
    }

    @Override
    public synchronized V getView() {
        if (this.proxy != null) {
            return this.proxy;
        }
        Log.e((String)this.getClass().getName(), (String)"there are some problems because is returning the original view");
        return this.original;
    }

    private class Handler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (Presenter.this.original != null) {
                return method.invoke((Object)Presenter.this.original, args);
            }
            Log.w((String)this.getClass().getName(), (String)"view is null so just ignore the call");
            return null;
        }
    }
}

