/*
 * Decompiled with CFR 0.152.
 */
package com.mellivora.swipe.touch;

import android.graphics.Canvas;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.mellivora.swipe.touch.OnItemMoveListener;
import com.mellivora.swipe.touch.OnItemMovementListener;
import com.mellivora.swipe.touch.OnItemStateChangedListener;

public class DefaultItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    private OnItemMovementListener onItemMovementListener;
    private OnItemMoveListener onItemMoveListener;
    private OnItemStateChangedListener onItemStateChangedListener;
    private boolean isItemViewSwipeEnabled;
    private boolean isLongPressDragEnabled;

    public void setLongPressDragEnabled(boolean canDrag) {
        this.isLongPressDragEnabled = canDrag;
    }

    public boolean isLongPressDragEnabled() {
        return this.isLongPressDragEnabled;
    }

    public void setItemViewSwipeEnabled(boolean canSwipe) {
        this.isItemViewSwipeEnabled = canSwipe;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.isItemViewSwipeEnabled;
    }

    public void setOnItemMoveListener(OnItemMoveListener onItemMoveListener) {
        this.onItemMoveListener = onItemMoveListener;
    }

    public OnItemMoveListener getOnItemMoveListener() {
        return this.onItemMoveListener;
    }

    public void setOnItemMovementListener(OnItemMovementListener onItemMovementListener) {
        this.onItemMovementListener = onItemMovementListener;
    }

    public OnItemMovementListener getOnItemMovementListener() {
        return this.onItemMovementListener;
    }

    public void setOnItemStateChangedListener(OnItemStateChangedListener onItemStateChangedListener) {
        this.onItemStateChangedListener = onItemStateChangedListener;
    }

    public OnItemStateChangedListener getOnItemStateChangedListener() {
        return this.onItemStateChangedListener;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder targetViewHolder) {
        if (this.onItemMovementListener != null) {
            int dragFlags = this.onItemMovementListener.onDragFlags(recyclerView, targetViewHolder);
            int swipeFlags = this.onItemMovementListener.onSwipeFlags(recyclerView, targetViewHolder);
            return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            if (linearLayoutManager.getOrientation() == 0) {
                int dragFlags = 15;
                int swipeFlags = 3;
                return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
            }
            int dragFlags = 15;
            int swipeFlags = 12;
            return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            if (linearLayoutManager.getOrientation() == 0) {
                int dragFlags = 12;
                int swipeFlags = 3;
                return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
            }
            int dragFlags = 3;
            int swipeFlags = 12;
            return DefaultItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }
        return DefaultItemTouchHelperCallback.makeMovementFlags((int)0, (int)0);
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        if (actionState == 1) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            float alpha = 1.0f;
            if (layoutManager instanceof LinearLayoutManager) {
                int orientation = ((LinearLayoutManager)layoutManager).getOrientation();
                if (orientation == 0) {
                    alpha = 1.0f - Math.abs(dY) / (float)viewHolder.itemView.getHeight();
                } else if (orientation == 1) {
                    alpha = 1.0f - Math.abs(dX) / (float)viewHolder.itemView.getWidth();
                }
            }
            viewHolder.itemView.setAlpha(alpha);
        }
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    public boolean onMove(RecyclerView arg0, RecyclerView.ViewHolder srcHolder, RecyclerView.ViewHolder targetHolder) {
        if (this.onItemMoveListener != null) {
            return this.onItemMoveListener.onItemMove(srcHolder, targetHolder);
        }
        return false;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        if (this.onItemMoveListener != null) {
            this.onItemMoveListener.onItemDismiss(viewHolder);
        }
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        super.onSelectedChanged(viewHolder, actionState);
        if (this.onItemStateChangedListener != null && actionState != 0) {
            this.onItemStateChangedListener.onSelectedChanged(viewHolder, actionState);
        }
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        if (this.onItemStateChangedListener != null) {
            this.onItemStateChangedListener.onSelectedChanged(viewHolder, 0);
        }
    }
}

