/*
 * Decompiled with CFR 0.152.
 */
package com.mellivora.swipe;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.mellivora.swipe.SwipeMenu;
import com.mellivora.swipe.SwipeMenuBridge;
import com.mellivora.swipe.SwipeMenuItem;
import com.mellivora.swipe.SwipeMenuItemClickListener;
import com.mellivora.swipe.SwipeSwitch;
import java.util.List;

public class SwipeMenuView
extends LinearLayout
implements View.OnClickListener {
    private RecyclerView.ViewHolder mAdapterVIewHolder;
    private SwipeSwitch mSwipeSwitch;
    private SwipeMenuItemClickListener mItemClickListener;
    private int mDirection;

    public SwipeMenuView(Context context) {
        this(context, null);
    }

    public SwipeMenuView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void createMenu(SwipeMenu swipeMenu, SwipeSwitch swipeSwitch, SwipeMenuItemClickListener swipeMenuItemClickListener, int direction) {
        this.removeAllViews();
        this.mSwipeSwitch = swipeSwitch;
        this.mItemClickListener = swipeMenuItemClickListener;
        this.mDirection = direction;
        List<SwipeMenuItem> items = swipeMenu.getMenuItems();
        for (int i = 0; i < items.size(); ++i) {
            TextView tv;
            SwipeMenuItem item = items.get(i);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(item.getWidth(), item.getHeight());
            params.weight = item.getWeight();
            LinearLayout parent = new LinearLayout(this.getContext());
            parent.setId(i);
            parent.setGravity(17);
            parent.setOrientation(1);
            parent.setLayoutParams((ViewGroup.LayoutParams)params);
            ViewCompat.setBackground((View)parent, (Drawable)item.getBackground());
            parent.setOnClickListener((View.OnClickListener)this);
            this.addView((View)parent);
            SwipeMenuBridge menuBridge = new SwipeMenuBridge(this.mDirection, i, this.mSwipeSwitch, (View)parent);
            parent.setTag((Object)menuBridge);
            if (item.getImage() != null) {
                ImageView iv;
                menuBridge.mImageView = iv = this.createIcon(item);
                parent.addView((View)iv);
            }
            if (TextUtils.isEmpty((CharSequence)item.getText())) continue;
            menuBridge.mTextView = tv = this.createTitle(item);
            parent.addView((View)tv);
        }
    }

    public void bindViewHolder(RecyclerView.ViewHolder adapterVIewHolder) {
        this.mAdapterVIewHolder = adapterVIewHolder;
    }

    private ImageView createIcon(SwipeMenuItem item) {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setImageDrawable(item.getImage());
        return imageView;
    }

    private TextView createTitle(SwipeMenuItem item) {
        Typeface typeface;
        int textAppearance;
        ColorStateList textColor;
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)item.getText());
        textView.setGravity(17);
        int textSize = item.getTextSize();
        if (textSize > 0) {
            textView.setTextSize((float)textSize);
        }
        if ((textColor = item.getTitleColor()) != null) {
            textView.setTextColor(textColor);
        }
        if ((textAppearance = item.getTextAppearance()) != 0) {
            TextViewCompat.setTextAppearance((TextView)textView, (int)textAppearance);
        }
        if ((typeface = item.getTextTypeface()) != null) {
            textView.setTypeface(typeface);
        }
        return textView;
    }

    public void onClick(View v) {
        if (this.mItemClickListener != null && this.mSwipeSwitch.isMenuOpen()) {
            SwipeMenuBridge menuBridge = (SwipeMenuBridge)v.getTag();
            menuBridge.mAdapterPosition = this.mAdapterVIewHolder.getAdapterPosition();
            this.mItemClickListener.onItemClick(menuBridge);
        }
    }
}

