/*
 * Decompiled with CFR 0.152.
 */
package com.mellivora.swipe;

import android.content.Context;
import com.mellivora.swipe.SwipeMenuItem;
import com.mellivora.swipe.SwipeMenuLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class SwipeMenu {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private SwipeMenuLayout mSwipeMenuLayout;
    private int mViewType;
    private int orientation = 0;
    private List<SwipeMenuItem> mSwipeMenuItems = new ArrayList<SwipeMenuItem>(2);

    public SwipeMenu(SwipeMenuLayout swipeMenuLayout, int viewType) {
        this.mSwipeMenuLayout = swipeMenuLayout;
        this.mViewType = viewType;
    }

    public void setOpenPercent(float openPercent) {
        if (openPercent != this.mSwipeMenuLayout.getOpenPercent()) {
            openPercent = openPercent > 1.0f ? 1.0f : (openPercent < 0.0f ? 0.0f : openPercent);
            this.mSwipeMenuLayout.setOpenPercent(openPercent);
        }
    }

    public void setScrollerDuration(int scrollerDuration) {
        this.mSwipeMenuLayout.setScrollerDuration(scrollerDuration);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Use SwipeMenu#HORIZONTAL or SwipeMenu#VERTICAL.");
        }
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void addMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.add(item);
    }

    public void removeMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.remove(item);
    }

    public List<SwipeMenuItem> getMenuItems() {
        return this.mSwipeMenuItems;
    }

    public SwipeMenuItem getMenuItem(int index) {
        return this.mSwipeMenuItems.get(index);
    }

    public Context getContext() {
        return this.mSwipeMenuLayout.getContext();
    }

    public int getViewType() {
        return this.mViewType;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

