/*
 * Decompiled with CFR 0.152.
 */
package com.mellivora.swipe;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.collection.SparseArrayCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.mellivora.pullview.R;
import com.mellivora.swipe.SwipeItemClickListener;
import com.mellivora.swipe.SwipeMenu;
import com.mellivora.swipe.SwipeMenuCreator;
import com.mellivora.swipe.SwipeMenuItemClickListener;
import com.mellivora.swipe.SwipeMenuLayout;
import com.mellivora.swipe.SwipeMenuView;
import java.lang.reflect.Field;
import java.util.List;

public class SwipeAdapterWrapper
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int BASE_ITEM_TYPE_HEADER = 100000;
    private static final int BASE_ITEM_TYPE_FOOTER = 200000;
    private SparseArrayCompat<View> mHeaderViews = new SparseArrayCompat();
    private SparseArrayCompat<View> mFootViews = new SparseArrayCompat();
    private RecyclerView.Adapter mAdapter;
    private LayoutInflater mInflater;
    private SwipeMenuCreator mSwipeMenuCreator;
    private SwipeMenuItemClickListener mSwipeMenuItemClickListener;
    private SwipeItemClickListener mSwipeItemClickListener;

    SwipeAdapterWrapper(Context context, RecyclerView.Adapter adapter) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mAdapter = adapter;
    }

    public RecyclerView.Adapter getOriginAdapter() {
        return this.mAdapter;
    }

    void setSwipeMenuCreator(SwipeMenuCreator swipeMenuCreator) {
        this.mSwipeMenuCreator = swipeMenuCreator;
    }

    void setSwipeMenuItemClickListener(SwipeMenuItemClickListener swipeMenuItemClickListener) {
        this.mSwipeMenuItemClickListener = swipeMenuItemClickListener;
    }

    void setSwipeItemClickListener(SwipeItemClickListener swipeItemClickListener) {
        this.mSwipeItemClickListener = swipeItemClickListener;
    }

    public int getItemCount() {
        return this.getHeaderItemCount() + this.getContentItemCount() + this.getFooterItemCount();
    }

    private int getContentItemCount() {
        return this.mAdapter.getItemCount();
    }

    public int getItemViewType(int position) {
        if (this.isHeaderView(position)) {
            return this.mHeaderViews.keyAt(position);
        }
        if (this.isFooterView(position)) {
            return this.mFootViews.keyAt(position - this.getHeaderItemCount() - this.getContentItemCount());
        }
        return this.mAdapter.getItemViewType(position - this.getHeaderItemCount());
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mHeaderViews.get(viewType) != null) {
            return new ViewHolder((View)this.mHeaderViews.get(viewType));
        }
        if (this.mFootViews.get(viewType) != null) {
            return new ViewHolder((View)this.mFootViews.get(viewType));
        }
        final RecyclerView.ViewHolder viewHolder = this.mAdapter.onCreateViewHolder(parent, viewType);
        if (this.mSwipeItemClickListener != null) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SwipeAdapterWrapper.this.mSwipeItemClickListener.onItemClick(v, viewHolder.getAdapterPosition());
                }
            });
        }
        if (this.mSwipeMenuCreator == null) {
            return viewHolder;
        }
        SwipeMenuLayout swipeMenuLayout = (SwipeMenuLayout)this.mInflater.inflate(R.layout.recycler_swipe_view_item, parent, false);
        SwipeMenu swipeLeftMenu = new SwipeMenu(swipeMenuLayout, viewType);
        SwipeMenu swipeRightMenu = new SwipeMenu(swipeMenuLayout, viewType);
        this.mSwipeMenuCreator.onCreateMenu(swipeLeftMenu, swipeRightMenu, viewType);
        int leftMenuCount = swipeLeftMenu.getMenuItems().size();
        int rightMenuCount = swipeRightMenu.getMenuItems().size();
        if (leftMenuCount == 0 && rightMenuCount == 0) {
            return viewHolder;
        }
        if (leftMenuCount > 0) {
            SwipeMenuView swipeLeftMenuView = (SwipeMenuView)swipeMenuLayout.findViewById(R.id.swipe_left);
            swipeLeftMenuView.setOrientation(swipeLeftMenu.getOrientation());
            swipeLeftMenuView.createMenu(swipeLeftMenu, swipeMenuLayout, this.mSwipeMenuItemClickListener, 1);
        }
        if (rightMenuCount > 0) {
            SwipeMenuView swipeRightMenuView = (SwipeMenuView)swipeMenuLayout.findViewById(R.id.swipe_right);
            swipeRightMenuView.setOrientation(swipeRightMenu.getOrientation());
            swipeRightMenuView.createMenu(swipeRightMenu, swipeMenuLayout, this.mSwipeMenuItemClickListener, -1);
        }
        ViewGroup viewGroup = (ViewGroup)swipeMenuLayout.findViewById(R.id.swipe_content);
        viewGroup.addView(viewHolder.itemView);
        try {
            Field itemView = this.getSupperClass(viewHolder.getClass()).getDeclaredField("itemView");
            if (!itemView.isAccessible()) {
                itemView.setAccessible(true);
            }
            itemView.set(viewHolder, swipeMenuLayout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return viewHolder;
    }

    private Class<?> getSupperClass(Class<?> aClass) {
        Class<?> supperClass = aClass.getSuperclass();
        if (supperClass != null && !supperClass.equals(Object.class)) {
            return this.getSupperClass(supperClass);
        }
        return aClass;
    }

    public final void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
    }

    public final void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (this.isHeaderView(position) || this.isFooterView(position)) {
            return;
        }
        View itemView = holder.itemView;
        if (itemView instanceof SwipeMenuLayout) {
            SwipeMenuLayout swipeMenuLayout = (SwipeMenuLayout)itemView;
            int childCount = swipeMenuLayout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView = swipeMenuLayout.getChildAt(i);
                if (!(childView instanceof SwipeMenuView)) continue;
                ((SwipeMenuView)childView).bindViewHolder(holder);
            }
        }
        this.mAdapter.onBindViewHolder(holder, position - this.getHeaderItemCount(), payloads);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.mAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        if (this.isHeaderView(position) || this.isFooterView(position)) {
            ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
            if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams) {
                StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
                p.setFullSpan(true);
            }
        } else {
            this.mAdapter.onViewAttachedToWindow(holder);
        }
    }

    public boolean isHeaderView(int position) {
        return position >= 0 && position < this.getHeaderItemCount();
    }

    public boolean isFooterView(int position) {
        return position >= this.getHeaderItemCount() + this.getContentItemCount();
    }

    public void addHeaderView(View view) {
        this.mHeaderViews.put(this.getHeaderItemCount() + 100000, (Object)view);
    }

    public void addHeaderViewAndNotify(View view) {
        this.mHeaderViews.put(this.getHeaderItemCount() + 100000, (Object)view);
        this.notifyItemInserted(this.getHeaderItemCount() - 1);
    }

    public void removeHeaderViewAndNotify(View view) {
        int headerIndex = this.mHeaderViews.indexOfValue((Object)view);
        this.mHeaderViews.removeAt(headerIndex);
        this.notifyItemRemoved(headerIndex);
    }

    public void addFooterView(View view) {
        this.mFootViews.put(this.getFooterItemCount() + 200000, (Object)view);
    }

    public void addFooterViewAndNotify(View view) {
        Log.i((String)"Test", (String)(view.hashCode() + "--\u6dfb\u52a0--" + view));
        this.mFootViews.put(this.getFooterItemCount() + 200000, (Object)view);
        this.notifyItemInserted(this.getHeaderItemCount() + this.getContentItemCount() + this.getFooterItemCount() - 1);
    }

    public void removeFooterViewAndNotify(View view) {
        int footerIndex = this.mFootViews.indexOfValue((Object)view);
        Log.i((String)"Test", (String)(view.hashCode() + "--\u79fb\u9664--" + view));
        this.mFootViews.removeAt(footerIndex);
        this.notifyItemRemoved(this.getHeaderItemCount() + this.getContentItemCount() + footerIndex);
    }

    public int getHeaderItemCount() {
        return this.mHeaderViews.size();
    }

    public int getFooterItemCount() {
        return this.mFootViews.size();
    }

    public void setHasStableIds(boolean hasStableIds) {
        this.mAdapter.setHasStableIds(hasStableIds);
    }

    public long getItemId(int position) {
        if (!this.isHeaderView(position) && !this.isFooterView(position)) {
            return this.mAdapter.getItemId(position);
        }
        return super.getItemId(position);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        if (!this.isHeaderView(position) && !this.isFooterView(position)) {
            this.mAdapter.onViewRecycled(holder);
        }
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        if (!this.isHeaderView(position) && !this.isFooterView(position)) {
            return this.mAdapter.onFailedToRecycleView(holder);
        }
        return false;
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        if (!this.isHeaderView(position) && !this.isFooterView(position)) {
            this.mAdapter.onViewDetachedFromWindow(holder);
        }
    }

    public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        super.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        super.unregisterAdapterDataObserver(observer);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.mAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }
    }
}

