/*
 * Decompiled with CFR 0.152.
 */
package com.mellivora.multiple;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.mellivora.multiple.api.MultipleStatus;
import com.mellivora.multiple.api.StatusViewCreator;
import com.mellivora.multiple.status.EmptyStatusView;
import com.mellivora.multiple.status.ErrorStatusView;
import com.mellivora.multiple.status.LoadingStatusView;
import com.mellivora.multiple.status.NetErrorStatusView;
import org.jetbrains.annotations.NotNull;

public class MultipleStatusView
extends RelativeLayout {
    private static final String TAG = "MultipleStatusView";
    public static final int STATUS_CONTENT = 0;
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_EMPTY = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_NO_NETWORK = 4;
    protected static StatusViewCreator loadingCreator = new StatusViewCreator(){

        @Override
        public MultipleStatus createStatusView(@NotNull Context context, @NotNull MultipleStatusView layout2) {
            return new LoadingStatusView();
        }
    };
    protected static StatusViewCreator errorCreator = new StatusViewCreator(){

        @Override
        public MultipleStatus createStatusView(@NotNull Context context, @NotNull MultipleStatusView layout2) {
            return new ErrorStatusView();
        }
    };
    protected static StatusViewCreator emptyCreator = new StatusViewCreator(){

        @Override
        public MultipleStatus createStatusView(@NotNull Context context, @NotNull MultipleStatusView layout2) {
            return new EmptyStatusView();
        }
    };
    protected static StatusViewCreator netErrorCreator = new StatusViewCreator(){

        @Override
        public MultipleStatus createStatusView(@NotNull Context context, @NotNull MultipleStatusView layout2) {
            return new NetErrorStatusView();
        }
    };
    private MultipleStatus mEmptyStatus;
    private MultipleStatus mErrorStatus;
    private MultipleStatus mLoadingStatus;
    private MultipleStatus mNoNetworkStatus;
    private View mEmptyView;
    private View mErrorView;
    private View mLoadingView;
    private View mNoNetworkView;
    private int mViewStatus = -1;
    private View.OnClickListener mOnRetryClickListener;
    private OnViewStatusChangeListener mViewStatusListener;

    public MultipleStatusView(Context context) {
        this(context, null);
    }

    public MultipleStatusView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MultipleStatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mLoadingStatus = loadingCreator.createStatusView(context, this);
        this.mEmptyStatus = emptyCreator.createStatusView(context, this);
        this.mErrorStatus = errorCreator.createStatusView(context, this);
        this.mNoNetworkStatus = netErrorCreator.createStatusView(context, this);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.showContent();
        this.mViewStatus = -1;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public int getViewStatus() {
        return this.mViewStatus;
    }

    public boolean isLoading() {
        return this.mViewStatus == 1;
    }

    public boolean isSuccess() {
        return this.mViewStatus == 0;
    }

    public void setOnRetryClickListener(View.OnClickListener onRetryClickListener) {
        this.mOnRetryClickListener = onRetryClickListener;
    }

    public static void setLoadingCreator(StatusViewCreator creator) {
        loadingCreator = creator;
    }

    public static void setEmptyCreator(StatusViewCreator creator) {
        emptyCreator = creator;
    }

    public static void setErrorCreator(StatusViewCreator creator) {
        errorCreator = creator;
    }

    public static void setNetErrorCreator(StatusViewCreator creator) {
        netErrorCreator = creator;
    }

    public void setLoadingStatus(MultipleStatus status) {
        if (this.mLoadingView != null) {
            this.removeView(this.mLoadingView);
            this.mLoadingView = null;
        }
        this.mLoadingStatus = status;
    }

    public void setEmptyStatus(MultipleStatus status) {
        if (this.mEmptyView != null) {
            this.removeView(this.mEmptyView);
            this.mEmptyView = null;
        }
        this.mEmptyStatus = status;
    }

    public void setErrorStatus(MultipleStatus status) {
        if (this.mErrorView != null) {
            this.removeView(this.mErrorView);
            this.mErrorView = null;
        }
        this.mErrorStatus = status;
    }

    public void setNetErrorStatus(MultipleStatus status) {
        if (this.mNoNetworkView != null) {
            this.removeView(this.mNoNetworkView);
            this.mNoNetworkView = null;
        }
        this.mNoNetworkStatus = status;
    }

    public final void showLoading(String hint) {
        this.changeViewStatus(1);
        if (null == this.mLoadingView) {
            this.mLoadingView = this.mLoadingStatus.getView(this.getContext(), this);
            this.addView(this.mLoadingView, 0, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }
        this.showViewByStatus(this.mLoadingView);
        this.mLoadingStatus.showMessage(this.mLoadingView, hint);
    }

    public final void showError(String hint) {
        this.changeViewStatus(3);
        if (null == this.mErrorView) {
            this.mErrorView = this.mErrorStatus.getView(this.getContext(), this);
            View clickView = this.mErrorStatus.getRetryView(this.mErrorView);
            if (clickView != null) {
                clickView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.addView(this.mErrorView, 0, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }
        this.showViewByStatus(this.mErrorView);
        this.mErrorStatus.showMessage(this.mErrorView, hint);
    }

    public final void showEmpty(String hint) {
        this.changeViewStatus(2);
        if (null == this.mEmptyView) {
            this.mEmptyView = this.mEmptyStatus.getView(this.getContext(), this);
            View clickView = this.mEmptyStatus.getRetryView(this.mEmptyView);
            if (clickView != null) {
                clickView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.addView(this.mEmptyView, 0, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }
        this.showViewByStatus(this.mEmptyView);
        this.mEmptyStatus.showMessage(this.mEmptyView, hint);
    }

    public final void showNoNetwork(String hint) {
        this.changeViewStatus(4);
        if (null == this.mNoNetworkView) {
            this.mNoNetworkView = this.mNoNetworkStatus.getView(this.getContext(), this);
            View clickView = this.mNoNetworkStatus.getRetryView(this.mNoNetworkView);
            if (clickView != null) {
                clickView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.addView(this.mNoNetworkView, 0, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }
        this.showViewByStatus(this.mNoNetworkView);
        this.mNoNetworkStatus.showMessage(this.mNoNetworkView, hint);
    }

    public final void showContent() {
        this.changeViewStatus(0);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (view == this.mLoadingView) {
                view.setVisibility(8);
                continue;
            }
            if (view == this.mEmptyView) {
                view.setVisibility(8);
                continue;
            }
            if (view == this.mErrorView) {
                view.setVisibility(8);
                continue;
            }
            if (view == this.mNoNetworkView) {
                view.setVisibility(8);
                continue;
            }
            view.setVisibility(0);
        }
    }

    private void showViewByStatus(View statusView) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view;
            view.setVisibility((view = this.getChildAt(i)) == statusView ? 0 : 8);
        }
    }

    private void checkNull(Object object, String hint) {
        if (null == object) {
            throw new NullPointerException(hint);
        }
    }

    private void clear(View ... views) {
        if (null == views) {
            return;
        }
        try {
            for (View view : views) {
                if (null == view) continue;
                this.removeView(view);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnViewStatusChangeListener(OnViewStatusChangeListener onViewStatusChangeListener) {
        this.mViewStatusListener = onViewStatusChangeListener;
    }

    private void changeViewStatus(int newViewStatus) {
        if (this.mViewStatus == newViewStatus) {
            return;
        }
        if (null != this.mViewStatusListener) {
            this.mViewStatusListener.onChange(this.mViewStatus, newViewStatus);
        }
        this.mViewStatus = newViewStatus;
    }

    public static interface OnViewStatusChangeListener {
        public void onChange(int var1, int var2);
    }
}

