/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.response.handler;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.R;
import com.meizu.cloud.pushsdk.a.a;
import com.meizu.cloud.pushsdk.c.b;
import com.meizu.cloud.pushsdk.g.c;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.response.MessageListener;
import com.meizu.cloud.pushsdk.response.data.MessageData;
import com.meizu.cloud.pushsdk.response.data.NotificationCoreData;

public abstract class MessageHandler<T> {
    private static final String TAG = "MessageHandler";
    private static final int RETRY_DOWNLOAD_PUBLIC_KEY_COUNT = 2;

    private boolean checkPublicKey(String string2, MessageData messageData, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            com.meizu.cloud.pushsdk.f.a.b(TAG, "security check fail, public key is null");
            return false;
        }
        String string4 = com.meizu.cloud.pushsdk.e.c.a(string2, string3);
        com.meizu.cloud.pushsdk.f.a.c(TAG, "decrypt sign: " + (String)string4);
        boolean bl = b.a(string4, messageData);
        com.meizu.cloud.pushsdk.f.a.c(TAG, "check public key result: " + bl);
        return bl;
    }

    private String getNetworkRequestPublicKey() {
        c c2;
        Object object = null;
        for (int i = 0; i < 2 && ((c2 = com.meizu.cloud.pushsdk.g.a.a("https://api-push.meizu.com/garcia/api/server/getPublicKey", null, null)) == null || c2.b() != 200 || TextUtils.isEmpty((CharSequence)(object = new b.a(c2.a()).a()))); ++i) {
        }
        return object;
    }

    public abstract String getMethod();

    public boolean messageMatch(Intent intent) {
        boolean bl = "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && this.getMethod().equals(intent.getStringExtra("method"));
        com.meizu.cloud.pushsdk.f.a.c(TAG, "messageMatch result: " + bl);
        return bl;
    }

    protected String getMessageValue(Intent intent) {
        block3: {
            MessageV3 messageV3 = (MessageV3)intent.getParcelableExtra("pushMessage");
            if (messageV3 == null) break block3;
            try {
                return MessageV3.messageV3ToString(messageV3);
            }
            catch (Exception exception) {
                com.meizu.cloud.pushsdk.f.a.b(TAG, "getMessageValue error, " + exception);
            }
        }
        return intent.getStringExtra("messageValue");
    }

    protected boolean securityCheck(Context context, T t) {
        return true;
    }

    protected abstract T getMessage(Context var1, Intent var2);

    public void onMessageBefore(Context context, T t) {
    }

    public boolean condition(Context context, Intent intent, T t) {
        return true;
    }

    public abstract void onMessage(Context var1, T var2, MessageListener var3);

    protected boolean securityCheckMessage(Context context, MessageData messageData) {
        if (messageData == null) {
            com.meizu.cloud.pushsdk.f.a.b(TAG, "security check, message is Null");
            return false;
        }
        String string2 = b.a(messageData);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            com.meizu.cloud.pushsdk.f.a.b(TAG, "message does not contain signature field");
            return false;
        }
        String string3 = com.meizu.cloud.pushsdk.h.a.b(context);
        com.meizu.cloud.pushsdk.f.a.c(TAG, "local public key is: " + string3);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = context.getString(R.string.security_public_key);
            com.meizu.cloud.pushsdk.f.a.c(TAG, "resources public key is: " + string3);
        }
        if (((MessageHandler)((Object)string4)).checkPublicKey(string3, messageData, string2)) {
            com.meizu.cloud.pushsdk.f.a.c(TAG, "security check passed");
            return true;
        }
        MessageHandler messageHandler = string4;
        String string4 = messageHandler.getNetworkRequestPublicKey();
        com.meizu.cloud.pushsdk.f.a.c(TAG, "network request public key: " + (String)string4);
        if (messageHandler.checkPublicKey(string4, messageData, string2)) {
            com.meizu.cloud.pushsdk.h.a.e(context, string4);
            com.meizu.cloud.pushsdk.f.a.c(TAG, "security check passed");
            return true;
        }
        com.meizu.cloud.pushsdk.f.a.b(TAG, "security check fail");
        return false;
    }

    public boolean sendMessage(Context context, Intent intent, MessageListener messageListener) {
        if (!this.messageMatch(intent)) {
            return false;
        }
        T t = this.getMessage(context, intent);
        if (!this.securityCheck(context, t)) {
            com.meizu.cloud.pushsdk.f.a.b(TAG, "invalid push message");
            return false;
        }
        com.meizu.cloud.pushsdk.f.a.c(TAG, "current Handler message " + t);
        this.onMessageBefore(context, t);
        if (this.condition(context, intent, t)) {
            this.onMessage(context, t, messageListener);
        }
        com.meizu.cloud.pushsdk.f.a.c(TAG, "send message end ");
        return true;
    }

    protected void clearNotification(Context object, MessageData messageData) {
        NotificationCoreData notificationCoreData = messageData.getNotificationCoreData();
        if (notificationCoreData == null) {
            return;
        }
        com.meizu.cloud.pushsdk.f.a.b(TAG, "delete notifyId " + notificationCoreData.getNotifyId() + " notifyKey " + notificationCoreData.getNotifyKey());
        if (!TextUtils.isEmpty((CharSequence)notificationCoreData.getNotifyKey())) {
            a.a().a((Context)object, notificationCoreData.getNotifyKey());
        } else {
            Context context = object;
            int n = notificationCoreData.getNotifyId();
            int[] nArray = new int[1];
            object = nArray;
            nArray[0] = n;
            a.a().a(context, (int[])object);
        }
    }
}

