/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.util.ArrayList;
import java.util.List;

public class AllergySystemUtils {
    private static final String TAG = "AllergySystemUtils";

    public static String getBssId(Context context) {
        String string = null;
        try {
            WifiInfo wifiInfo;
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                string = wifiInfo.getBSSID();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getBssId error " + exception.getMessage());
        }
        return string;
    }

    public static String getOperator(Context context) {
        String string = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                string = telephonyManager.getSimOperator();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getOperator error " + exception.getMessage());
        }
        return string;
    }

    public static List<String> getWifiList(Context context) {
        ArrayList<String> arrayList;
        block4: {
            arrayList = new ArrayList<String>();
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager == null) break block4;
                List list = wifiManager.getScanResults();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (list == null) break block4;
                for (ScanResult scanResult : list) {
                    if (!arrayList2.contains(scanResult.SSID)) {
                        String string = scanResult.SSID + ";" + scanResult.BSSID + ";" + scanResult.level;
                        arrayList.add(string);
                        arrayList2.add(scanResult.SSID);
                    }
                    if (arrayList.size() < 10) continue;
                    break;
                }
            }
            catch (Exception exception) {
                DebugLogger.e(TAG, "getWifiList error " + exception.getMessage());
            }
        }
        return arrayList;
    }
}

