/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.notification.model.NotifyType;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvanceSetting
implements Parcelable {
    private int netWorkType = 1;
    private NotifyType notifyType;
    private boolean clearNotification = true;
    private boolean headUpNotification = true;
    private int priorityDisplay = 0;
    public static final int MZ_PUSH_PRIORITY_MIN = -2;
    public static final int MZ_PUSH_PRIORITY_LOW = -1;
    public static final int MZ_PUSH_PRIORITY_DEFAULT = 0;
    public static final int MZ_PUSH_PRIORITY_HIGH = 1;
    public static final int MZ_PUSH_PRIORITY_MAX = 2;
    public static final String TAG = "advance_setting";
    public static final String ADVANCE_SETTING = "as";
    public static final String NETWORK_TYPE = "it";
    public static final String NOTIFY_TYPE = "nt";
    public static final String CLEAR_NOTIFICATION = "cn";
    public static final String HEAD_UP_NOTIFICATION = "hn";
    public static final String PRIORITY_DISPLAY = "pd";
    public static final Parcelable.Creator<AdvanceSetting> CREATOR = new Parcelable.Creator<AdvanceSetting>(){

        public AdvanceSetting a(Parcel parcel) {
            return new AdvanceSetting(parcel);
        }

        public AdvanceSetting[] a(int n2) {
            return new AdvanceSetting[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public AdvanceSetting() {
    }

    public AdvanceSetting(Parcel parcel) {
        this.netWorkType = parcel.readInt();
        this.notifyType = (NotifyType)parcel.readParcelable(NotifyType.class.getClassLoader());
        this.clearNotification = parcel.readByte() != 0;
        this.headUpNotification = parcel.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.netWorkType);
        parcel.writeParcelable((Parcelable)this.notifyType, n2);
        parcel.writeByte((byte)(this.clearNotification ? 1 : 0));
        parcel.writeByte((byte)(this.headUpNotification ? 1 : 0));
    }

    public int getNetWorkType() {
        return this.netWorkType;
    }

    public void setNetWorkType(int n2) {
        this.netWorkType = n2;
    }

    public NotifyType getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(NotifyType notifyType) {
        this.notifyType = notifyType;
    }

    public boolean isClearNotification() {
        return this.clearNotification;
    }

    public void setClearNotification(boolean bl) {
        this.clearNotification = bl;
    }

    public boolean isHeadUpNotification() {
        return this.headUpNotification;
    }

    public void setHeadUpNotification(boolean bl) {
        this.headUpNotification = bl;
    }

    public int getPriorityDisplay() {
        return this.priorityDisplay;
    }

    public void setPriorityDisplay(int n2) {
        if (n2 < -2 || n2 > 2) {
            n2 = 0;
        }
        this.priorityDisplay = n2;
    }

    public static AdvanceSetting parse(String string) {
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                jSONObject = new JSONObject(string);
            }
            catch (JSONException jSONException) {
                DebugLogger.e(TAG, "parse json string error " + jSONException.getMessage());
            }
        }
        return AdvanceSetting.parse(jSONObject);
    }

    public static AdvanceSetting parse(JSONObject jSONObject) {
        AdvanceSetting advanceSetting = new AdvanceSetting();
        if (jSONObject != null) {
            try {
                if (!jSONObject.isNull(NETWORK_TYPE)) {
                    advanceSetting.setNetWorkType(jSONObject.getInt(NETWORK_TYPE));
                }
                if (!jSONObject.isNull(NOTIFY_TYPE)) {
                    advanceSetting.setNotifyType(NotifyType.parse(jSONObject.getJSONObject(NOTIFY_TYPE)));
                }
                if (!jSONObject.isNull(CLEAR_NOTIFICATION)) {
                    advanceSetting.setClearNotification(jSONObject.getInt(CLEAR_NOTIFICATION) != 0);
                }
                if (!jSONObject.isNull(HEAD_UP_NOTIFICATION)) {
                    advanceSetting.setHeadUpNotification(jSONObject.getInt(HEAD_UP_NOTIFICATION) != 0);
                }
                if (!jSONObject.isNull(PRIORITY_DISPLAY)) {
                    advanceSetting.setPriorityDisplay(jSONObject.getInt(PRIORITY_DISPLAY));
                }
            }
            catch (JSONException jSONException) {
                DebugLogger.e(TAG, "parse json obj error " + jSONException.getMessage());
            }
        } else {
            DebugLogger.e(TAG, "no such tag advance_setting");
        }
        return advanceSetting;
    }

    public String toString() {
        return "AdvanceSetting{netWorkType=" + this.netWorkType + ", notifyType=" + this.notifyType + ", clearNotification=" + this.clearNotification + ", headUpNotification=" + this.headUpNotification + ", priorityDisplay=" + this.priorityDisplay + '}';
    }
}

