/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AllergySystemUtils {
    private static final String TAG = "AllergySystemUtils";

    public static String getBSSID(Context context) {
        String string = null;
        try {
            WifiInfo wifiInfo;
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                string = wifiInfo.getBSSID();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getBSSID error " + exception.getMessage());
        }
        return string;
    }

    public static String getOperator(Context context) {
        String string = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                string = telephonyManager.getSimOperator();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getOperator error " + exception.getMessage());
        }
        return string;
    }

    private static Object getPhoneInfo(Context context, int n2, String string) {
        Object object = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (Build.VERSION.SDK_INT >= 21) {
                Method method = telephonyManager.getClass().getMethod(string, AllergySystemUtils.getMethodParamTypes(string));
                if (n2 >= 0) {
                    object = method.invoke((Object)telephonyManager, n2);
                }
            }
        }
        catch (Exception exception) {
            DebugLogger.d(TAG, exception.toString());
        }
        return object;
    }

    private static Class[] getMethodParamTypes(String string) {
        Class<?>[] classArray = null;
        try {
            Method[] methodArray = TelephonyManager.class.getDeclaredMethods();
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!string.equals(methodArray[i2].getName()) || (classArray = methodArray[i2].getParameterTypes()).length < 1) continue;
                DebugLogger.d(TAG, "getMethodParamTypes " + classArray.length);
                break;
            }
        }
        catch (Exception exception) {
            DebugLogger.d(TAG, "getMethodParamTypes " + exception.toString());
        }
        return classArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSubId(Context context, int n2) {
        Cursor cursor = null;
        try {
            Uri uri = Uri.parse((String)"content://telephony/siminfo");
            ContentResolver contentResolver = context.getContentResolver();
            cursor = contentResolver.query(uri, new String[]{"_id", "sim_id"}, "sim_id = ?", new String[]{String.valueOf(n2)}, null);
            if (null != cursor && cursor.moveToFirst()) {
                int n3 = cursor.getInt(cursor.getColumnIndex("_id"));
                return n3;
            }
        }
        catch (Exception exception) {
            DebugLogger.d(TAG, "getSubId " + exception.toString());
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return -1;
    }

    public static String getSubscriberId(Context context, int n2) {
        if (Build.VERSION.SDK_INT >= 29) {
            return "";
        }
        Object object = AllergySystemUtils.getPhoneInfo(context, n2, "getSubscriberId");
        return null != object ? (String)object : "";
    }

    public static List<String> getWifiList(Context context) {
        ArrayList<String> arrayList;
        block4: {
            arrayList = new ArrayList<String>();
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager == null) break block4;
                List list = wifiManager.getScanResults();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (list == null) break block4;
                for (ScanResult scanResult : list) {
                    if (!arrayList2.contains(scanResult.SSID)) {
                        String string = scanResult.SSID + ";" + scanResult.BSSID + ";" + scanResult.level;
                        arrayList.add(string);
                        arrayList2.add(scanResult.SSID);
                    }
                    if (arrayList.size() < 10) continue;
                    break;
                }
            }
            catch (Exception exception) {
                DebugLogger.e(TAG, "getWifiList error " + exception.getMessage());
            }
        }
        return arrayList;
    }

    public static String getLineNumber(Context context) {
        String string = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                string = telephonyManager.getLine1Number();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getLineNumber error " + exception.getMessage());
        }
        return string;
    }
}

