/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.c.b;
import com.meizu.cloud.pushsdk.notification.c.c;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSetting;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import org.json.JSONObject;

public abstract class a
implements com.meizu.cloud.pushsdk.notification.c {
    protected Context a;
    protected PushNotificationBuilder b;
    private NotificationManager d;
    protected Handler c;

    protected a(Context context, PushNotificationBuilder pushNotificationBuilder) {
        this.b = pushNotificationBuilder;
        this.a = context;
        this.c = new Handler(context.getMainLooper());
        this.d = (NotificationManager)context.getSystemService("notification");
    }

    protected void a(Notification.Builder builder, MessageV3 messageV3) {
    }

    protected void a(Notification notification, MessageV3 messageV3) {
    }

    protected void b(Notification notification, MessageV3 messageV3) {
    }

    protected void b(Notification.Builder builder, MessageV3 messageV3) {
    }

    protected Notification a(MessageV3 messageV3, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        Notification.Builder builder = new Notification.Builder(this.a);
        this.a(builder, messageV3, pendingIntent, pendingIntent2);
        this.c(builder, messageV3);
        this.b(builder, messageV3);
        this.a(builder, messageV3);
        this.a(builder);
        Notification notification = MinSdkChecker.isSupportNotificationBuild() ? builder.build() : builder.getNotification();
        this.c(notification, messageV3);
        this.a(notification, messageV3);
        this.b(notification, messageV3);
        return notification;
    }

    protected PendingIntent a(MessageV3 messageV3) {
        if (messageV3.getWhiteList() && !MzSystemUtils.isExistReceiver(this.a, messageV3.getUploadDataPackageName(), "com.meizu.flyme.push.intent.MESSAGE")) {
            return this.a(messageV3, messageV3.getPackageName());
        }
        return this.a(messageV3, messageV3.getUploadDataPackageName());
    }

    private PendingIntent a(MessageV3 messageV3, String string) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        intent.putExtra("pushMessage", (Parcelable)messageV3);
        intent.putExtra("method", "private");
        String string2 = MzSystemUtils.findReceiver(this.a, "com.meizu.flyme.push.intent.MESSAGE", string);
        intent.setClassName(string, string2);
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        intent.setFlags(32);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.a, (int)0, (Intent)intent, (int)0x40000000);
        return pendingIntent;
    }

    protected PendingIntent b(MessageV3 messageV3) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        intent.putExtra("pushMessage", (Parcelable)messageV3);
        intent.putExtra("method", "notification_delete");
        String string = MzSystemUtils.findReceiver(this.a, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName());
        intent.setClassName(messageV3.getPackageName(), string);
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.a, (int)0, (Intent)intent, (int)0x40000000);
        return pendingIntent;
    }

    protected PendingIntent c(MessageV3 messageV3) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        intent.putExtra("notification_state_message", messageV3.getNotificationMessage());
        intent.putExtra("notification_extra_task_id", messageV3.getTaskId());
        intent.putExtra("notification_extra_seq_id", messageV3.getSeqId());
        intent.putExtra("notification_extra_device_id", messageV3.getDeviceId());
        intent.putExtra("notification_extra_push_timestamp", messageV3.getPushTimestamp());
        intent.putExtra("notification_extra_show_package_name", messageV3.getUploadDataPackageName());
        intent.putExtra("mz_push_white_list", messageV3.getWhiteList());
        intent.putExtra("mz_push_delayed_report_millis", messageV3.getDelayedReportMillis());
        intent.putExtra("method", "notification_state");
        String string = MzSystemUtils.findReceiver(this.a, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName());
        intent.setClassName(messageV3.getPackageName(), string);
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.a, (int)0, (Intent)intent, (int)0x40000000);
        return pendingIntent;
    }

    protected void a(Notification.Builder builder, MessageV3 messageV3, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        builder.setContentTitle((CharSequence)messageV3.getTitle());
        builder.setContentText((CharSequence)messageV3.getContent());
        builder.setTicker((CharSequence)messageV3.getTitle());
        builder.setAutoCancel(true);
        if (MinSdkChecker.isSupportSendNotification()) {
            builder.setVisibility(1);
        }
        if (MinSdkChecker.isSupportSetDrawableSmallIcon()) {
            Icon icon = this.b(messageV3.getUploadDataPackageName());
            if (icon != null) {
                builder.setSmallIcon(icon);
            } else {
                DebugLogger.e("AbstractPushNotification", "cannot get " + messageV3.getUploadDataPackageName() + " smallIcon");
                builder.setSmallIcon(com.meizu.cloud.pushsdk.notification.c.c.l(this.a));
            }
        } else {
            builder.setSmallIcon(this.b != null && this.b.getmStatusbarIcon() != 0 ? this.b.getmStatusbarIcon() : com.meizu.cloud.pushsdk.notification.c.c.l(this.a));
        }
        builder.setContentIntent(pendingIntent);
        builder.setDeleteIntent(pendingIntent2);
    }

    protected void c(Notification.Builder builder, MessageV3 messageV3) {
        AdvanceSetting advanceSetting = messageV3.getmAdvanceSetting();
        if (advanceSetting != null) {
            if (advanceSetting.getNotifyType() != null) {
                boolean bl = advanceSetting.getNotifyType().isVibrate();
                boolean bl2 = advanceSetting.getNotifyType().isLights();
                boolean bl3 = advanceSetting.getNotifyType().isSound();
                if (bl || bl2 || bl3) {
                    int n2 = 0;
                    if (bl) {
                        n2 |= 2;
                    }
                    if (bl2) {
                        n2 |= 4;
                    }
                    if (bl3) {
                        n2 |= 1;
                    }
                    DebugLogger.e("AbstractPushNotification", "current notification type is " + n2);
                    builder.setDefaults(n2);
                }
            }
            builder.setOngoing(!advanceSetting.isClearNotification());
            if (advanceSetting.isHeadUpNotification() && MinSdkChecker.isSupportNotificationBuild()) {
                builder.setPriority(2);
            }
        }
    }

    public Bitmap a(String string) {
        com.meizu.cloud.pushsdk.b.a.b b2 = com.meizu.cloud.pushsdk.b.a.a(string).a();
        com.meizu.cloud.pushsdk.b.a.c c2 = b2.b();
        if (c2.b() && c2.a() != null) {
            DebugLogger.i("AbstractPushNotification", "ANRequest On other Thread down load largeIcon " + string + "image " + (c2.a() != null ? "success" : "fail"));
            return (Bitmap)c2.a();
        }
        DebugLogger.i("AbstractPushNotification", "ANRequest On other Thread down load largeIcon " + string + "image fail");
        return null;
    }

    @TargetApi(value=23)
    private Icon b(String string) {
        Icon icon = null;
        try {
            Resources resources = this.a.getPackageManager().getResourcesForApplication(string);
            int n2 = resources.getIdentifier("mz_push_notification_small_icon", "drawable", string);
            if (n2 != 0) {
                DebugLogger.i("AbstractPushNotification", "get " + string + " smallIcon success resId " + n2);
                icon = Icon.createWithResource((String)string, (int)n2);
            }
        }
        catch (Exception exception) {
            DebugLogger.e("AbstractPushNotification", "cannot load smallIcon form package " + string + " Error message " + exception.getMessage());
        }
        return icon;
    }

    public Bitmap a(Context context, String string) {
        Bitmap bitmap = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            Drawable drawable = packageManager.getApplicationIcon(string);
            BitmapDrawable bitmapDrawable = null;
            if (Build.VERSION.SDK_INT >= 26) {
                if (drawable instanceof BitmapDrawable) {
                    bitmapDrawable = (BitmapDrawable)drawable;
                } else if (drawable instanceof AdaptiveIconDrawable) {
                    Bitmap bitmap2 = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas canvas = new Canvas(bitmap2);
                    drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                    drawable.draw(canvas);
                    bitmap = bitmap2;
                }
            } else {
                bitmapDrawable = (BitmapDrawable)drawable;
            }
            if (bitmap == null) {
                bitmap = bitmapDrawable.getBitmap();
            }
        }
        catch (Exception exception) {
            DebugLogger.i("AbstractPushNotification", "getappicon error " + exception.getMessage());
            BitmapDrawable bitmapDrawable = (BitmapDrawable)context.getApplicationInfo().loadIcon(context.getPackageManager());
            bitmap = bitmapDrawable.getBitmap();
        }
        return bitmap;
    }

    public String b(Context context, String string) {
        String string2 = null;
        try {
            CharSequence charSequence;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            if (applicationInfo != null && (charSequence = packageManager.getApplicationLabel(applicationInfo)) != null) {
                string2 = (String)charSequence;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            DebugLogger.e("AbstractPushNotification", "can not find " + string + " application info");
        }
        return string2;
    }

    protected boolean a() {
        return Thread.currentThread() == this.a.getMainLooper().getThread();
    }

    protected String d(MessageV3 messageV3) {
        String string = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)messageV3.getNotificationMessage())) {
                JSONObject jSONObject = new JSONObject(messageV3.getNotificationMessage());
                string = jSONObject.getJSONObject("data").getJSONObject("extra").getString("fns");
            }
        }
        catch (Exception exception) {
            DebugLogger.e("AbstractPushNotification", "parse flyme notifification setting error " + exception.getMessage());
        }
        DebugLogger.i("AbstractPushNotification", "current FlymeGreen notification setting is " + string);
        return string;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void e(MessageV3 messageV3) {
        Notification notification = this.a(messageV3, this.a(messageV3), this.b(messageV3));
        int n2 = Math.abs((int)System.currentTimeMillis());
        com.meizu.cloud.pushsdk.notification.model.a a2 = com.meizu.cloud.pushsdk.notification.model.a.a(messageV3);
        if (a2 != null && a2.a() != 0) {
            n2 = a2.a();
            DebugLogger.e("AbstractPushNotification", "server notify id " + n2);
            if (!TextUtils.isEmpty((CharSequence)a2.b())) {
                int n3 = com.meizu.cloud.pushsdk.util.b.i(this.a, messageV3.getUploadDataPackageName(), a2.b());
                DebugLogger.e("AbstractPushNotification", "notifyKey " + a2.b() + " preference notifyId is " + n3);
                if (n3 != 0) {
                    DebugLogger.e("AbstractPushNotification", "use preference notifyId " + n3 + " and cancel it");
                    this.d.cancel(n3);
                }
                DebugLogger.e("AbstractPushNotification", "store new notifyId " + n2 + " by notifyKey " + a2.b());
                com.meizu.cloud.pushsdk.util.b.b(this.a, messageV3.getUploadDataPackageName(), a2.b(), n2);
            }
        }
        DebugLogger.e("AbstractPushNotification", "current notify id " + n2);
        if (messageV3.isDiscard()) {
            if (com.meizu.cloud.pushsdk.util.b.c(this.a, messageV3.getPackageName()) == 0) {
                com.meizu.cloud.pushsdk.util.b.a(this.a, messageV3.getPackageName(), n2);
                DebugLogger.i("AbstractPushNotification", "no notification show so put notification id " + n2);
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getTaskId())) {
                if (com.meizu.cloud.pushsdk.util.b.d(this.a, messageV3.getPackageName()) == 0) {
                    com.meizu.cloud.pushsdk.util.b.b(this.a, messageV3.getPackageName(), Integer.valueOf(messageV3.getTaskId()));
                } else {
                    if (Integer.valueOf(messageV3.getTaskId()) < com.meizu.cloud.pushsdk.util.b.d(this.a, messageV3.getPackageName())) {
                        DebugLogger.i("AbstractPushNotification", "current package " + messageV3.getPackageName() + " taskid " + messageV3.getTaskId() + " dont show notification");
                        return;
                    }
                    com.meizu.cloud.pushsdk.util.b.b(this.a, messageV3.getPackageName(), Integer.valueOf(messageV3.getTaskId()));
                    n2 = com.meizu.cloud.pushsdk.util.b.c(this.a, messageV3.getPackageName());
                }
            }
            DebugLogger.i("AbstractPushNotification", "current package " + messageV3.getPackageName() + " notificationId=" + n2 + " taskId=" + messageV3.getTaskId());
        }
        this.d.notify(n2, notification);
        this.a(this.d, n2, messageV3);
    }

    @SuppressLint(value={"NewApi"})
    private void c(Notification notification, MessageV3 messageV3) {
        com.meizu.cloud.pushsdk.notification.c.b.a(notification, true);
        com.meizu.cloud.pushsdk.notification.c.b.a(notification, this.c(messageV3));
        notification.extras.putString("android.originalPackageName", messageV3.getUploadDataPackageName());
        notification.extras.putString("android.flymeNotificationSetting", this.d(messageV3));
        notification.extras.putString("notification_extra_task_id", messageV3.getTaskId());
        notification.extras.putString("notification_extra_seq_id", messageV3.getSeqId());
        notification.extras.putString("notification_extra_device_id", messageV3.getDeviceId());
        notification.extras.putString("notification_extra_push_timestamp", messageV3.getPushTimestamp());
        if (!TextUtils.isEmpty((CharSequence)this.b.getAppLabel())) {
            DebugLogger.e("AbstractPushNotification", "set app label " + this.b.getAppLabel());
            notification.extras.putString("android.substName", this.b.getAppLabel());
        } else {
            String string = this.b(this.a, messageV3.getUploadDataPackageName());
            DebugLogger.e("AbstractPushNotification", "current package " + messageV3.getUploadDataPackageName() + " label is " + string);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                notification.extras.putString("android.substName", string);
            }
        }
    }

    protected void a(final NotificationManager notificationManager, final int n2, MessageV3 messageV3) {
        AdvanceSetting advanceSetting = messageV3.getmAdvanceSetting();
        if (advanceSetting != null) {
            boolean bl = advanceSetting.isHeadUpNotification();
            boolean bl2 = advanceSetting.isClearNotification();
            if (bl && !bl2) {
                messageV3.getmAdvanceSetting().setHeadUpNotification(false);
                messageV3.getmAdvanceSetting().getNotifyType().setSound(false);
                messageV3.getmAdvanceSetting().getNotifyType().setVibrate(false);
                final Notification notification = this.a(messageV3, this.a(messageV3), this.b(messageV3));
                this.c.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        notificationManager.notify(n2, notification);
                    }
                }, 5000L);
            }
        }
    }

    private void a(Notification.Builder builder) {
        if (MinSdkChecker.isSupportNotificationChannel()) {
            DebugLogger.e("AbstractPushNotification", "support notification channel on non meizu device");
            NotificationChannel notificationChannel = new NotificationChannel("mz_push_notification_channel", (CharSequence)"MEIZUPUSH", 3);
            notificationChannel.enableLights(true);
            notificationChannel.setLightColor(-16711936);
            notificationChannel.setShowBadge(true);
            this.d.createNotificationChannel(notificationChannel);
            builder.setChannelId("mz_push_notification_channel");
        }
    }
}

