/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.a.a;
import com.meizu.cloud.pushsdk.base.c;
import com.meizu.cloud.pushsdk.base.k;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MzSystemUtils {
    private static final String TAG = "MzSystemUtils";

    private static String getServicesByPackageName(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        ServiceInfo[] serviceInfoArray = null;
        try {
            serviceInfoArray = packageManager.getPackageInfo((String)string, (int)4).services;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serviceInfoArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < serviceInfoArray.length; ++i2) {
            if (!"com.meizu.cloud.pushsdk.pushservice.MzPushService".equals(serviceInfoArray[i2].name)) continue;
            return serviceInfoArray[i2].processName;
        }
        return null;
    }

    public static String getMzPushServicePackageName(Context context) {
        String string = context.getPackageName();
        try {
            String string2 = MzSystemUtils.getServicesByPackageName(context, "com.meizu.cloud");
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.contains("mzservice_v1")) {
                string = "com.meizu.cloud";
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DebugLogger.i("SystemUtils", "startservice package name " + string);
        return string;
    }

    public static String getAppVersionName(Context context, String string) {
        String string2 = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            string2 = packageInfo.versionName;
            if (string2 == null || string2.length() <= 0) {
                return "";
            }
        }
        catch (Exception exception) {
            DebugLogger.e("VersionInfo", "Exception message " + exception.getMessage());
            return "";
        }
        return string2;
    }

    public static boolean compareVersion(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n2 = Math.min(stringArray.length, stringArray2.length);
        int n3 = 0;
        for (int i2 = 0; i2 < n2 && (n3 = stringArray[i2].length() - stringArray2[i2].length()) == 0 && (n3 = stringArray[i2].compareTo(stringArray2[i2])) == 0; ++i2) {
        }
        n3 = n3 != 0 ? n3 : stringArray.length - stringArray2.length;
        return n3 >= 0;
    }

    public static void sendMessageFromBroadcast(Context context, Intent intent, String string, String string2) {
        String string3;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            intent.setAction(string);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            intent.setPackage(string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(string3 = MzSystemUtils.findReceiver(context, string, string2)))) {
            intent.setClassName(string2, string3);
        }
        context.sendBroadcast(intent);
    }

    public static String findReceiver(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        Intent intent = new Intent(string);
        intent.setPackage(string2);
        List list = context.getPackageManager().queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            return ((ResolveInfo)list.get((int)0)).activityInfo.name;
        }
        return null;
    }

    public static String getDeviceId(Context context) {
        String string = null;
        try {
            string = c.a(context);
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getDeviceId error " + exception.getMessage());
        }
        return string;
    }

    public static boolean isBrandMeizu(Context context) {
        boolean bl;
        String string = k.a("ro.meizu.product.model");
        boolean bl2 = bl = !TextUtils.isEmpty((CharSequence)string) || "meizu".equalsIgnoreCase(Build.BRAND) || "22c4185e".equalsIgnoreCase(Build.BRAND);
        if (!bl) {
            a.b(context.getApplicationContext());
        }
        return bl;
    }

    public static boolean isMeizu(Context context) {
        return MzSystemUtils.isBrandMeizu(context);
    }

    public static boolean isHuaWei() {
        String string = k.a("ro.build.version.emui");
        DebugLogger.e(TAG, "huawei eui " + string);
        return !TextUtils.isEmpty((CharSequence)string);
    }

    public static boolean isXiaoMi() {
        return "Xiaomi".equals(Build.MODEL) || "Xiaomi".equals(Build.MANUFACTURER);
    }

    public static boolean isInternational() {
        return com.meizu.cloud.pushsdk.base.a.a().a ? (Boolean)com.meizu.cloud.pushsdk.base.a.a().b : false;
    }

    public static boolean isIndiaLocal() {
        String string = k.a("ro.meizu.locale.region");
        return "india".equals(string);
    }

    public static String getSubscriberId(Context context) {
        String string = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                string = telephonyManager.getSubscriberId();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getSubscribeId error " + exception.getMessage());
        }
        return string;
    }

    public static String getLineNumber(Context context) {
        String string = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                string = telephonyManager.getLine1Number();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getLineNumber error " + exception.getMessage());
        }
        return string;
    }

    public static String getOperator(Context context) {
        String string = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                string = telephonyManager.getSimOperator();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getOperator error " + exception.getMessage());
        }
        return string;
    }

    public static String getNetWorkType(Context context) {
        String string = "";
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                int n2 = networkInfo.getType();
                switch (n2) {
                    case 1: {
                        string = "WIFI";
                        break;
                    }
                    case 9: {
                        string = "ETHERNET";
                        break;
                    }
                    case 7: {
                        string = "BLUETOOTH";
                        break;
                    }
                    case 0: {
                        switch (networkInfo.getSubtype()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: 
                            case 11: {
                                string = "MOBILE_2G";
                                break;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 12: 
                            case 14: 
                            case 15: {
                                string = "MOBILE_3G";
                                break;
                            }
                            case 13: {
                                string = "MOBILE_4G";
                                break;
                            }
                            default: {
                                string = "MOBILE_XG";
                            }
                        }
                    }
                    default: {
                        string = "OTHER";
                    }
                }
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "Security exception checking connection: " + exception.getMessage());
        }
        return string;
    }

    public static String getWifiMac(Context context) {
        String string = null;
        try {
            WifiInfo wifiInfo;
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                string = wifiInfo.getMacAddress();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getWifiMac error " + exception.getMessage());
        }
        return string;
    }

    public static String getBSSID(Context context) {
        String string = null;
        try {
            WifiInfo wifiInfo;
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                string = wifiInfo.getBSSID();
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getOperator error " + exception.getMessage());
        }
        return string;
    }

    public static List<String> getWifiList(Context context) {
        ArrayList<String> arrayList;
        block4: {
            arrayList = new ArrayList<String>();
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager == null) break block4;
                List list = wifiManager.getScanResults();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (list == null) break block4;
                for (ScanResult scanResult : list) {
                    if (!arrayList2.contains(scanResult.SSID)) {
                        String string = scanResult.SSID + ";" + scanResult.BSSID + ";" + scanResult.level;
                        arrayList.add(string);
                        arrayList2.add(scanResult.SSID);
                    }
                    if (arrayList.size() < 10) continue;
                    break;
                }
            }
            catch (Exception exception) {
                DebugLogger.e(TAG, "getWifiList error " + exception.getMessage());
            }
        }
        return arrayList;
    }

    public static String getCurrentLanguage() {
        try {
            String string = Locale.getDefault().getLanguage();
            return string;
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getCurrentLanguage error " + exception.getMessage());
            return null;
        }
    }

    public static boolean isApplicationDebug(Context context) {
        boolean bl = false;
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            bl = (applicationInfo.flags & 2) != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int getAppVersionCode(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean compatApi(int n2) {
        return Build.VERSION.SDK_INT >= n2;
    }

    public static String getSn() {
        String string = k.a("ro.serialno");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return Build.SERIAL;
    }

    public static boolean isPackageInstalled(Context context, String string) {
        try {
            context.getPackageManager().getPackageInfo(string, 0);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isRunningProcess(Context context, String string) {
        boolean bl = false;
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                bl = runningAppProcessInfo.processName.contains(string);
                if (!bl) continue;
                break;
            }
            DebugLogger.i(TAG, string + " is running " + bl);
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "can not get running process info so set running true");
            bl = true;
        }
        return bl;
    }

    public static List<String> getRunningProcess(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                arrayList.add(runningAppProcessInfo.processName);
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "can not get running process info so set running true");
        }
        return arrayList;
    }

    public static List<String> getInstalledPackage(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List list;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (list = packageManager.getInstalledPackages(0)) != null) {
                for (PackageInfo packageInfo : list) {
                    arrayList.add(packageInfo.packageName);
                }
            }
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getInstalledPackage error " + exception.getMessage());
        }
        return arrayList;
    }

    public static String getProcessName(Context context) {
        try {
            int n2 = Process.myPid();
            String string = "";
            ActivityManager activityManager = (ActivityManager)context.getApplicationContext().getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : activityManager.getRunningAppProcesses()) {
                DebugLogger.i(TAG, "processName " + runningAppProcessInfo.processName);
                if (runningAppProcessInfo.pid != n2) continue;
                string = runningAppProcessInfo.processName;
                break;
            }
            return string;
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getProcessName error " + exception.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSubId(Context context, int n2) {
        Cursor cursor = null;
        try {
            Uri uri = Uri.parse((String)"content://telephony/siminfo");
            ContentResolver contentResolver = context.getContentResolver();
            cursor = contentResolver.query(uri, new String[]{"_id", "sim_id"}, "sim_id = ?", new String[]{String.valueOf(n2)}, null);
            if (null != cursor && cursor.moveToFirst()) {
                int n3 = cursor.getInt(cursor.getColumnIndex("_id"));
                return n3;
            }
        }
        catch (Exception exception) {
            DebugLogger.d(TAG, "getSubId " + exception.toString());
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return -1;
    }

    public static Class[] getMethodParamTypes(String string) {
        Class<?>[] classArray = null;
        try {
            Method[] methodArray = TelephonyManager.class.getDeclaredMethods();
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!string.equals(methodArray[i2].getName()) || (classArray = methodArray[i2].getParameterTypes()).length < 1) continue;
                DebugLogger.d(TAG, "getMethodParamTypes " + classArray.length);
                break;
            }
        }
        catch (Exception exception) {
            DebugLogger.d(TAG, "getMethodParamTypes " + exception.toString());
        }
        return classArray;
    }

    public static Object getPhoneInfo(Context context, int n2, String string) {
        Object object = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (Build.VERSION.SDK_INT >= 21) {
                Method method = telephonyManager.getClass().getMethod(string, MzSystemUtils.getMethodParamTypes(string));
                if (n2 >= 0) {
                    object = method.invoke((Object)telephonyManager, n2);
                }
            }
        }
        catch (Exception exception) {
            DebugLogger.d(TAG, exception.toString());
        }
        return object;
    }

    public static String getDeviceId(Context context, int n2) {
        Object object = MzSystemUtils.getPhoneInfo(context, n2, "getDeviceId");
        return null != object ? (String)object : "";
    }

    public static String getSubscriberId(Context context, int n2) {
        Object object = MzSystemUtils.getPhoneInfo(context, n2, "getSubscriberId");
        return null != object ? (String)object : "";
    }
}

