/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.BuildExt;
import com.meizu.cloud.pushsdk.base.DeviceUtils;
import com.meizu.cloud.pushsdk.base.SystemProperties;
import java.util.List;

public class MzSystemUtils {
    private static final String TAG = "MzSystemUtils";

    private static String getServicesByPackageName(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        ServiceInfo[] serviceInfos = null;
        try {
            serviceInfos = packageManager.getPackageInfo((String)packageName, (int)4).services;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (serviceInfos == null) {
            return null;
        }
        for (int i = 0; i < serviceInfos.length; ++i) {
            if (!"com.meizu.cloud.pushsdk.pushservice.MzPushService".equals(serviceInfos[i].name)) continue;
            return serviceInfos[i].processName;
        }
        return null;
    }

    public static String getMzPushServicePackageName(Context context) {
        String packageName = context.getPackageName();
        try {
            String mzPushserviceProcessName = MzSystemUtils.getServicesByPackageName(context, "com.meizu.cloud");
            if (!TextUtils.isEmpty((CharSequence)mzPushserviceProcessName) && mzPushserviceProcessName.contains("mzservice_v1")) {
                packageName = "com.meizu.cloud";
                return packageName;
            }
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
        DebugLogger.i("SystemUtils", "startservice package name " + packageName);
        return packageName;
    }

    public static String getAppVersionName(Context context, String packageName) {
        String versionName = "";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            versionName = pi.versionName;
            if (versionName == null || versionName.length() <= 0) {
                return "";
            }
        }
        catch (Exception e) {
            DebugLogger.e("VersionInfo", "Exception message " + e.getMessage());
            return "";
        }
        return versionName;
    }

    public static boolean compareVersion(String version1, String version2) {
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff >= 0;
    }

    public static String findReceiver(Context paramContext, String action, String packageName) {
        if (TextUtils.isEmpty((CharSequence)action) || TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        Intent localIntent = new Intent(action);
        localIntent.setPackage(packageName);
        List localList = paramContext.getPackageManager().queryBroadcastReceivers(localIntent, 0);
        if (localList != null && localList.size() > 0) {
            return ((ResolveInfo)localList.get((int)0)).activityInfo.name;
        }
        return null;
    }

    public static String getDeviceId(Context context) {
        String deviceId = DeviceUtils.getDeviceId(context);
        return deviceId;
    }

    public static boolean isBrandMeizu() {
        String model = SystemProperties.get("ro.meizu.product.model");
        return !TextUtils.isEmpty((CharSequence)model) || "meizu".equalsIgnoreCase(Build.BRAND) || "22c4185e".equalsIgnoreCase(Build.BRAND);
    }

    public static boolean isInternational() {
        return BuildExt.isInternational().ok ? (Boolean)BuildExt.isInternational().value : false;
    }

    public static boolean isIndiaLocal() {
        String result = SystemProperties.get("ro.meizu.locale.region");
        return "india".equals(result);
    }

    public static boolean isApplicationDebug(Context context) {
        boolean isDebug = false;
        try {
            ApplicationInfo info = context.getApplicationInfo();
            isDebug = (info.flags & 2) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDebug;
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "";
        }
    }

    public static boolean compatApi(int apiLevel) {
        return Build.VERSION.SDK_INT >= apiLevel;
    }

    public static String getSn() {
        String result = SystemProperties.get("ro.serialno");
        if (!TextUtils.isEmpty((CharSequence)result)) {
            return result;
        }
        return Build.SERIAL;
    }

    public static String getProcessName(Context context) {
        int pid = Process.myPid();
        String processName = "";
        ActivityManager manager = (ActivityManager)context.getApplicationContext().getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo process : manager.getRunningAppProcesses()) {
            DebugLogger.i(TAG, "processName " + process.processName);
            if (process.pid != pid) continue;
            processName = process.processName;
            break;
        }
        return processName;
    }

    public static boolean isPackageInstalled(Context context, String packageName) {
        try {
            context.getPackageManager().getPackageInfo(packageName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

