/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.storage;

import com.meizu.cloud.pushsdk.pushtracer.dataload.DataLoad;
import com.meizu.cloud.pushsdk.pushtracer.dataload.TrackerDataload;
import com.meizu.cloud.pushsdk.pushtracer.emitter.EmittableEvents;
import com.meizu.cloud.pushsdk.pushtracer.storage.EventStore;
import com.meizu.cloud.pushsdk.pushtracer.storage.Store;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryStore
implements Store {
    private static final String TAG = "MemoryStore";
    private int sendLimit;
    private AtomicLong atomicLong = new AtomicLong(0L);
    private Map<Long, byte[]> storeMap = new ConcurrentHashMap<Long, byte[]>();
    private List<Long> dataKeyList = new CopyOnWriteArrayList<Long>();

    public MemoryStore(int sendLimit) {
        this.sendLimit = sendLimit;
    }

    @Override
    public void add(DataLoad dataLoad) {
        this.insertEvent(dataLoad);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
        this.storeMap.clear();
        this.atomicLong.set(0L);
        this.dataKeyList.clear();
    }

    @Override
    public boolean removeEvent(long id) {
        return this.dataKeyList.remove(id) && this.storeMap.remove(id) != null;
    }

    @Override
    public boolean removeAllEvents() {
        this.storeMap.clear();
        this.dataKeyList.clear();
        return true;
    }

    @Override
    public long getSize() {
        return this.dataKeyList.size();
    }

    @Override
    public EmittableEvents getEmittableEvents() {
        LinkedList<Long> eventIds = new LinkedList<Long>();
        ArrayList<DataLoad> events = new ArrayList<DataLoad>();
        int keySize = (int)this.getSize();
        int largeEmiteSize = keySize > this.sendLimit ? this.sendLimit : keySize;
        for (int i = 0; i < largeEmiteSize; ++i) {
            Map<String, Object> mapObj;
            Long key = this.dataKeyList.get(i);
            if (key == null) continue;
            TrackerDataload payload = new TrackerDataload();
            Map<String, Object> payloadMap = mapObj = EventStore.deserializer(this.storeMap.get(key));
            payload.addMap(payloadMap);
            Logger.i(TAG, " current key " + key + " payload " + payload, new Object[0]);
            eventIds.add(key);
            events.add(payload);
        }
        return new EmittableEvents(events, eventIds);
    }

    public long insertEvent(DataLoad dataLoad) {
        byte[] bytes = EventStore.serialize(dataLoad.getMap());
        long key = this.atomicLong.getAndIncrement();
        this.dataKeyList.add(key);
        this.storeMap.put(key, bytes);
        return key;
    }

    public Map<String, Object> getEvent(long id) {
        byte[] eventByte = this.storeMap.get(id);
        if (eventByte != null) {
            Map<String, Object> event = EventStore.deserializer(eventByte);
            return event;
        }
        return null;
    }
}

