/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.event;

import com.meizu.cloud.pushsdk.pushtracer.dataload.TrackerDataload;
import com.meizu.cloud.pushsdk.pushtracer.event.Event;

public class PushEvent
extends Event {
    private String eventName;
    private String taskId;
    private String deviceId;
    private String pushsdkVersion;
    private String packageName;
    private String seqId;
    private String messageSeq;
    private String eventCreateTime;

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected PushEvent(Builder<?> builder) {
        super(builder);
        this.taskId = ((Builder)builder).taskId;
        this.deviceId = ((Builder)builder).deviceId;
        this.eventName = ((Builder)builder).eventName;
        this.pushsdkVersion = ((Builder)builder).pushsdkVersion;
        this.packageName = ((Builder)builder).packageName;
        this.seqId = ((Builder)builder).seqId;
        this.messageSeq = ((Builder)builder).messageSeq;
        this.eventCreateTime = ((Builder)builder).eventCreateTime;
    }

    public TrackerDataload getDataLoad() {
        TrackerDataload dataLoad = new TrackerDataload();
        dataLoad.add("en", this.eventName);
        dataLoad.add("ti", this.taskId);
        dataLoad.add("di", this.deviceId);
        dataLoad.add("pv", this.pushsdkVersion);
        dataLoad.add("pn", this.packageName);
        dataLoad.add("si", this.seqId);
        dataLoad.add("ms", this.messageSeq);
        dataLoad.add("ect", this.eventCreateTime);
        return this.putDefaultParams(dataLoad);
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Event.Builder<T> {
        private String eventName;
        private String taskId;
        private String deviceId;
        private String pushsdkVersion;
        private String packageName;
        private String seqId;
        private String messageSeq;
        private String eventCreateTime;

        public T eventName(String eventName) {
            this.eventName = eventName;
            return (T)((Builder)this.self());
        }

        public T taskId(String taskId) {
            this.taskId = taskId;
            return (T)((Builder)this.self());
        }

        public T deviceId(String deviceId) {
            this.deviceId = deviceId;
            return (T)((Builder)this.self());
        }

        public T pushsdkVersion(String pushsdkVersion) {
            this.pushsdkVersion = pushsdkVersion;
            return (T)((Builder)this.self());
        }

        public T packageName(String packageName) {
            this.packageName = packageName;
            return (T)((Builder)this.self());
        }

        public T seqId(String seqId) {
            this.seqId = seqId;
            return (T)((Builder)this.self());
        }

        public T messageSeq(String messageSeq) {
            this.messageSeq = messageSeq;
            return (T)((Builder)this.self());
        }

        public T eventCreateTime(String eventCreateTime) {
            this.eventCreateTime = eventCreateTime;
            return (T)((Builder)this.self());
        }

        @Override
        public PushEvent build() {
            return new PushEvent(this);
        }
    }
}

