/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.pushtracer.emitter.BufferOption;
import com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter;
import com.meizu.cloud.pushsdk.pushtracer.emitter.RequestCallback;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Emitter;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Subject;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Tracker;
import com.meizu.cloud.pushsdk.pushtracer.utils.LogLevel;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class QuickTracker {
    public static final String namespace = "PushAndroidTracker";
    private static Tracker tracker;
    private static AtomicBoolean isRegisterNetReceiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Tracker init(Context context, boolean isUpload) {
        if (tracker == null) {
            Class<QuickTracker> clazz = QuickTracker.class;
            // MONITORENTER : com.meizu.cloud.pushsdk.pushtracer.QuickTracker.class
            if (tracker == null) {
                com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter emitter = QuickTracker.getEmitterClassic(context, null);
                tracker = QuickTracker.getTrackerClassic(emitter, null, context);
            }
            // MONITOREXIT : clazz
        }
        DebugLogger.i(namespace, "can upload subject " + isUpload);
        if (!isUpload) return tracker;
        Subject subject = QuickTracker.getSubject(context);
        tracker.setSubject(subject);
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Tracker getAndroidTrackerClassic(Context context, RequestCallback callback) {
        if (tracker == null) {
            Class<QuickTracker> clazz = QuickTracker.class;
            // MONITORENTER : com.meizu.cloud.pushsdk.pushtracer.QuickTracker.class
            if (tracker == null) {
                com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter emitter = QuickTracker.getEmitterClassic(context, callback);
                tracker = QuickTracker.getTrackerClassic(emitter, null, context);
            }
            // MONITOREXIT : clazz
        }
        if (!isRegisterNetReceiver.compareAndSet(false, true)) return tracker;
        QuickTracker.registerNetworkReceiver(context, tracker);
        return tracker;
    }

    private static Tracker getTrackerClassic(com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter emitter, Subject subject, Context context) {
        return new com.meizu.cloud.pushsdk.pushtracer.tracker.classic.Tracker(new Tracker.TrackerBuilder(emitter, namespace, context.getPackageCodePath(), context, com.meizu.cloud.pushsdk.pushtracer.tracker.classic.Tracker.class).level(LogLevel.VERBOSE).base64(false).subject(subject).threadCount(4));
    }

    private static com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter getEmitterClassic(Context context, RequestCallback callback) {
        return new Emitter(new Emitter.EmitterBuilder(QuickTracker.getStaticsDomain(), context, Emitter.class).callback(callback).tick(1).option(BufferOption.DefaultGroup).sendLimit(BufferOption.DefaultGroup.getCode()).emptyLimit(2));
    }

    private static Subject getSubject(Context context) {
        return new Subject.SubjectBuilder().context(context).build();
    }

    private static void registerNetworkReceiver(Context context, final Tracker tracker) {
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (Util.isOnline(context)) {
                    Logger.e("QuickTracker", "restart track event: %s", "online true");
                    tracker.restartEventTracking();
                }
            }
        }, filter);
    }

    private static String getStaticsDomain() {
        String staticsDomian = "push-statics.meizu.com";
        if (MzSystemUtils.isInternational() || MzSystemUtils.isIndiaLocal()) {
            return "push-statics.in.meizu.com";
        }
        DebugLogger.e("QuickTracker", "current statics domain is " + staticsDomian);
        return staticsDomian;
    }

    static {
        isRegisterNetReceiver = new AtomicBoolean(false);
    }
}

