/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.platform.pushstrategy.Strategy;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.concurrent.ScheduledExecutorService;

public class UnRegisterStatusStrategy
extends Strategy<UnRegisterStatus> {
    public UnRegisterStatusStrategy(Context context, String appId, String appKey, PushAPI pushAPI, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushAPI, executorService);
    }

    public UnRegisterStatusStrategy(Context context, PushAPI pushAPI, ScheduledExecutorService executorService) {
        this(context, null, null, pushAPI, executorService);
    }

    public UnRegisterStatusStrategy(Context context, PushAPI pushAPI, ScheduledExecutorService executorService, boolean enableRPC) {
        this(context, pushAPI, executorService);
        this.enableRPC = enableRPC;
    }

    @Override
    protected boolean matchCondition() {
        return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.appKey);
    }

    @Override
    protected UnRegisterStatus feedBackErrorResponse() {
        UnRegisterStatus registerStatus = new UnRegisterStatus();
        registerStatus.setCode("20001");
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            registerStatus.setMessage("appId not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            registerStatus.setMessage("appKey not empty");
        }
        return registerStatus;
    }

    @Override
    protected Intent sendRpcRequest() {
        Intent intent = new Intent();
        intent.putExtra("app_id", this.appId);
        intent.putExtra("app_key", this.appKey);
        intent.putExtra("strategy_package_name", this.context.getPackageName());
        intent.putExtra("strategy_type", this.strategyType());
        return intent;
    }

    @Override
    protected UnRegisterStatus netWorkRequest() {
        UnRegisterStatus unRegisterStatus = new UnRegisterStatus();
        String pushId = PushPreferencesUtils.getPushId(this.context, this.strategyPackageNanme);
        if (TextUtils.isEmpty((CharSequence)pushId)) {
            unRegisterStatus.setCode("200");
            unRegisterStatus.setMessage("already unRegister PushId,dont unRegister frequently");
            unRegisterStatus.setIsUnRegisterSuccess(true);
        } else {
            this.deviceId = this.getDeviceId();
            ANResponse anResponse = this.pushAPI.unRegister(this.appId, this.appKey, this.deviceId);
            if (anResponse.isSuccess()) {
                unRegisterStatus = new UnRegisterStatus((String)anResponse.getResult());
                DebugLogger.e("Strategy", "network unRegisterStatus " + unRegisterStatus);
                if ("200".equals(unRegisterStatus.getCode())) {
                    PushPreferencesUtils.putPushId(this.context, "", this.strategyPackageNanme);
                }
            } else {
                ANError error = anResponse.getError();
                if (error.getResponse() != null) {
                    DebugLogger.e("Strategy", "status code=" + error.getErrorCode() + " data=" + error.getResponse());
                }
                unRegisterStatus.setCode(String.valueOf(error.getErrorCode()));
                unRegisterStatus.setMessage(error.getErrorBody());
                DebugLogger.e("Strategy", "unRegisterStatus " + unRegisterStatus);
            }
        }
        return unRegisterStatus;
    }

    @Override
    protected UnRegisterStatus localResponse() {
        return null;
    }

    @Override
    protected void sendReceiverMessage(UnRegisterStatus message) {
        PlatformMessageSender.sendUnRegisterStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName(), message);
    }

    @Override
    protected int strategyType() {
        return 32;
    }
}

