/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.api;

import android.content.Context;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.networking.http.Response;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndStringRequestListener;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.StrategyMessage;
import com.meizu.cloud.pushsdk.platform.pushstrategy.RegisterStatusStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.SubScribeAliasStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.SubScribeTagStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.SwitchStatusStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.UnRegisterStatusStrategy;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Executor;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;

public class PushPlatformManager {
    private static final String TAG = "PushPlatformManager";
    private static PushPlatformManager mInstance;
    private ScheduledExecutorService executorService;
    private Context mContext;
    private PushAPI pushAPI;
    private RegisterStatusStrategy registerStatusStrategy;
    private UnRegisterStatusStrategy unRegisterStatusStrategy;
    private SwitchStatusStrategy switchStatusStrategy;
    private SubScribeTagStrategy subScribeTagStrategy;
    private SubScribeAliasStrategy subScribeAliasStrategy;

    public PushPlatformManager(Context context, boolean isAsync) {
        this(context, isAsync, true);
    }

    public PushPlatformManager(Context context, boolean isAsync, boolean enableRPC) {
        this.mContext = context.getApplicationContext();
        this.pushAPI = new PushAPI(this.mContext);
        if (isAsync) {
            this.executorService = (ScheduledExecutorService)Executor.getExecutor();
        }
        this.registerStatusStrategy = new RegisterStatusStrategy(this.mContext, this.pushAPI, this.executorService, enableRPC);
        this.unRegisterStatusStrategy = new UnRegisterStatusStrategy(this.mContext, this.pushAPI, this.executorService, enableRPC);
        this.switchStatusStrategy = new SwitchStatusStrategy(this.mContext, this.pushAPI, this.executorService, enableRPC);
        this.subScribeTagStrategy = new SubScribeTagStrategy(this.mContext, this.pushAPI, this.executorService, enableRPC);
        this.subScribeAliasStrategy = new SubScribeAliasStrategy(this.mContext, this.pushAPI, this.executorService, enableRPC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushPlatformManager getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<PushPlatformManager> clazz = PushPlatformManager.class;
        synchronized (PushPlatformManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PushPlatformManager(context, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void enableRemoteInvoker(boolean isRemoteInvoker) {
        this.registerStatusStrategy.setSupportRemoteInvoke(isRemoteInvoker);
        this.unRegisterStatusStrategy.setSupportRemoteInvoke(isRemoteInvoker);
        this.switchStatusStrategy.setSupportRemoteInvoke(isRemoteInvoker);
        this.subScribeAliasStrategy.setSupportRemoteInvoke(isRemoteInvoker);
        this.subScribeTagStrategy.setSupportRemoteInvoke(isRemoteInvoker);
    }

    public boolean dispatcherStrategyMessage(StrategyMessage strategyMessage) {
        boolean flag = true;
        if (strategyMessage != null) {
            int strategyType = strategyMessage.getStrategyType();
            switch (strategyType) {
                case 2: {
                    flag = this.register(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName());
                    break;
                }
                case 32: {
                    flag = this.unRegister(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName());
                    break;
                }
                case 4: {
                    if (0 == strategyMessage.getStrategyChildType()) {
                        flag = this.subScribeTags(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), strategyMessage.getParams());
                        break;
                    }
                    if (3 == strategyMessage.getStrategyChildType()) {
                        flag = this.checkSubScribeTags(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId());
                        break;
                    }
                    if (1 == strategyMessage.getStrategyChildType()) {
                        flag = this.unSubScribeTags(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), strategyMessage.getParams());
                        break;
                    }
                    if (2 != strategyMessage.getStrategyChildType()) break;
                    flag = this.unSubScribeAllTags(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId());
                    break;
                }
                case 16: {
                    if (0 == strategyMessage.getStrategyChildType()) {
                        flag = this.switchPush(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), 0, "1".equals(strategyMessage.getParams()));
                        break;
                    }
                    if (1 == strategyMessage.getStrategyChildType()) {
                        flag = this.switchPush(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), 1, "1".equals(strategyMessage.getParams()));
                        break;
                    }
                    if (3 == strategyMessage.getStrategyChildType()) {
                        flag = this.switchPush(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), "1".equals(strategyMessage.getParams()));
                        break;
                    }
                    if (2 != strategyMessage.getStrategyChildType()) break;
                    flag = this.checkPush(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId());
                    break;
                }
                case 8: {
                    if (0 == strategyMessage.getStrategyChildType()) {
                        flag = this.subScribeAlias(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), strategyMessage.getParams());
                        break;
                    }
                    if (1 == strategyMessage.getStrategyChildType()) {
                        flag = this.unSubScribeAlias(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), strategyMessage.getParams());
                        break;
                    }
                    if (2 != strategyMessage.getStrategyChildType()) break;
                    flag = this.checkSubScribeAlias(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId());
                }
            }
        }
        return flag;
    }

    public boolean register(String appId, String appKey, String packageName) {
        this.registerStatusStrategy.setAppId(appId);
        this.registerStatusStrategy.setAppKey(appKey);
        this.registerStatusStrategy.setStrategyPackageNanme(packageName);
        return this.registerStatusStrategy.process();
    }

    public boolean unRegister(String appId, String appKey, String packageName) {
        this.unRegisterStatusStrategy.setAppId(appId);
        this.unRegisterStatusStrategy.setAppKey(appKey);
        this.unRegisterStatusStrategy.setStrategyPackageNanme(packageName);
        return this.unRegisterStatusStrategy.process();
    }

    public void unRegisterAdvance(final String packageName, String deviceId) {
        this.pushAPI.unRegister(packageName, deviceId, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "unregisetr advance pakcage " + packageName + " result " + response);
            }

            @Override
            public void onError(ANError anError) {
                DebugLogger.e(PushPlatformManager.TAG, "unregisetr advance pakcage " + packageName + " error " + anError.getErrorBody());
            }
        });
    }

    public boolean checkPush(String appId, String appKey, String packageName, String pushId) {
        this.switchStatusStrategy.setAppId(appId);
        this.switchStatusStrategy.setAppKey(appKey);
        this.switchStatusStrategy.setStrategyPackageNanme(packageName);
        this.switchStatusStrategy.setPushId(pushId);
        this.switchStatusStrategy.setSwitchType(2);
        return this.switchStatusStrategy.process();
    }

    public boolean switchPush(String appId, String appKey, String packageName, String pushId, int msgType, boolean switcher) {
        this.switchStatusStrategy.setAppId(appId);
        this.switchStatusStrategy.setAppKey(appKey);
        this.switchStatusStrategy.setStrategyPackageNanme(packageName);
        this.switchStatusStrategy.setPushId(pushId);
        this.switchStatusStrategy.setSwitchType(msgType);
        this.switchStatusStrategy.setSwitcher(switcher);
        return this.switchStatusStrategy.process();
    }

    public boolean switchPush(String appId, String appKey, String packageName, String pushId, boolean switcher) {
        this.switchStatusStrategy.setAppId(appId);
        this.switchStatusStrategy.setAppKey(appKey);
        this.switchStatusStrategy.setStrategyPackageNanme(packageName);
        this.switchStatusStrategy.setPushId(pushId);
        this.switchStatusStrategy.setSwitchType(3);
        this.switchStatusStrategy.setSwitcher(switcher);
        return this.switchStatusStrategy.process();
    }

    public boolean subScribeTags(String appId, String appKey, String packageName, String pushId, String tags) {
        this.subScribeTagStrategy.setAppId(appId);
        this.subScribeTagStrategy.setAppKey(appKey);
        this.subScribeTagStrategy.setStrategyPackageNanme(packageName);
        this.subScribeTagStrategy.setPushId(pushId);
        this.subScribeTagStrategy.setSubTagType(0);
        this.subScribeTagStrategy.setSubTags(tags);
        return this.subScribeTagStrategy.process();
    }

    public boolean unSubScribeTags(String appId, String appKey, String packageName, String pushId, String tags) {
        this.subScribeTagStrategy.setAppId(appId);
        this.subScribeTagStrategy.setAppKey(appKey);
        this.subScribeTagStrategy.setStrategyPackageNanme(packageName);
        this.subScribeTagStrategy.setPushId(pushId);
        this.subScribeTagStrategy.setSubTagType(1);
        this.subScribeTagStrategy.setSubTags(tags);
        return this.subScribeTagStrategy.process();
    }

    public boolean unSubScribeAllTags(String appId, String appKey, String packageName, String pushId) {
        this.subScribeTagStrategy.setAppId(appId);
        this.subScribeTagStrategy.setAppKey(appKey);
        this.subScribeTagStrategy.setStrategyPackageNanme(packageName);
        this.subScribeTagStrategy.setPushId(pushId);
        this.subScribeTagStrategy.setSubTagType(2);
        return this.subScribeTagStrategy.process();
    }

    public boolean checkSubScribeTags(String appId, String appKey, String packageName, String pushId) {
        this.subScribeTagStrategy.setAppId(appId);
        this.subScribeTagStrategy.setAppKey(appKey);
        this.subScribeTagStrategy.setStrategyPackageNanme(packageName);
        this.subScribeTagStrategy.setPushId(pushId);
        this.subScribeTagStrategy.setSubTagType(3);
        return this.subScribeTagStrategy.process();
    }

    public boolean subScribeAlias(String appId, String appKey, String packageName, String pushId, String alias) {
        this.subScribeAliasStrategy.setAppId(appId);
        this.subScribeAliasStrategy.setAppKey(appKey);
        this.subScribeAliasStrategy.setStrategyPackageNanme(packageName);
        this.subScribeAliasStrategy.setPushId(pushId);
        this.subScribeAliasStrategy.setSubAliasType(0);
        this.subScribeAliasStrategy.setAlias(alias);
        return this.subScribeAliasStrategy.process();
    }

    public boolean unSubScribeAlias(String appId, String appKey, String packageName, String pushId, String alias) {
        this.subScribeAliasStrategy.setAppId(appId);
        this.subScribeAliasStrategy.setAppKey(appKey);
        this.subScribeAliasStrategy.setStrategyPackageNanme(packageName);
        this.subScribeAliasStrategy.setPushId(pushId);
        this.subScribeAliasStrategy.setSubAliasType(1);
        this.subScribeAliasStrategy.setAlias(alias);
        return this.subScribeAliasStrategy.process();
    }

    public boolean checkSubScribeAlias(String appId, String appKey, String packageName, String pushId) {
        this.subScribeAliasStrategy.setAppId(appId);
        this.subScribeAliasStrategy.setAppKey(appKey);
        this.subScribeAliasStrategy.setStrategyPackageNanme(packageName);
        this.subScribeAliasStrategy.setPushId(pushId);
        this.subScribeAliasStrategy.setSubAliasType(2);
        return this.subScribeAliasStrategy.process();
    }

    public ANResponse<String> uploadLogFile(String messageId, String deviceId, String errorMsg, File logFile) {
        return this.pushAPI.uploadLogFile(messageId, deviceId, errorMsg, logFile);
    }
}

