/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.notification.model.NotifyType;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvanceSetting
implements Parcelable {
    private int netWorkType = 1;
    private NotifyType notifyType;
    private boolean clearNotification = true;
    private boolean headUpNotification = true;
    public static final String TAG = "advance_setting";
    public static final String ADVANCE_SETTING = "as";
    public static final String NETWORK_TYPE = "it";
    public static final String NOTIFY_TYPE = "nt";
    public static final String CLEAR_NOTIFICATION = "cn";
    public static final String HEAD_UP_NOTIFICATION = "hn";
    public static final Parcelable.Creator<AdvanceSetting> CREATOR = new Parcelable.Creator<AdvanceSetting>(){

        public AdvanceSetting createFromParcel(Parcel in) {
            return new AdvanceSetting(in);
        }

        public AdvanceSetting[] newArray(int size) {
            return new AdvanceSetting[size];
        }
    };

    public AdvanceSetting() {
    }

    public AdvanceSetting(Parcel in) {
        this.netWorkType = in.readInt();
        this.notifyType = (NotifyType)in.readParcelable(NotifyType.class.getClassLoader());
        this.clearNotification = in.readByte() != 0;
        this.headUpNotification = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flag) {
        parcel.writeInt(this.netWorkType);
        parcel.writeParcelable((Parcelable)this.notifyType, flag);
        parcel.writeByte((byte)(this.clearNotification ? 1 : 0));
        parcel.writeByte((byte)(this.headUpNotification ? 1 : 0));
    }

    public int getNetWorkType() {
        return this.netWorkType;
    }

    public void setNetWorkType(int netWorkType) {
        this.netWorkType = netWorkType;
    }

    public NotifyType getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(NotifyType notifyType) {
        this.notifyType = notifyType;
    }

    public boolean isClearNotification() {
        return this.clearNotification;
    }

    public void setClearNotification(boolean clearNotification) {
        this.clearNotification = clearNotification;
    }

    public boolean isHeadUpNotification() {
        return this.headUpNotification;
    }

    public void setHeadUpNotification(boolean headUpNotification) {
        this.headUpNotification = headUpNotification;
    }

    public static AdvanceSetting parse(String setting) {
        JSONObject advanceObj = null;
        if (!TextUtils.isEmpty((CharSequence)setting)) {
            try {
                advanceObj = new JSONObject(setting);
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return AdvanceSetting.parse(advanceObj);
    }

    public static AdvanceSetting parse(JSONObject advanceObj) {
        AdvanceSetting advanceSetting = new AdvanceSetting();
        if (advanceObj != null) {
            try {
                if (!advanceObj.isNull(NETWORK_TYPE)) {
                    advanceSetting.setNetWorkType(advanceObj.getInt(NETWORK_TYPE));
                }
                if (!advanceObj.isNull(NOTIFY_TYPE)) {
                    advanceSetting.setNotifyType(NotifyType.parse(advanceObj.getJSONObject(NOTIFY_TYPE)));
                }
                if (!advanceObj.isNull(CLEAR_NOTIFICATION)) {
                    advanceSetting.setClearNotification(advanceObj.getInt(CLEAR_NOTIFICATION) != 0);
                }
                if (!advanceObj.isNull(HEAD_UP_NOTIFICATION)) {
                    advanceSetting.setHeadUpNotification(advanceObj.getInt(HEAD_UP_NOTIFICATION) != 0);
                }
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG, "no such tag advance_setting");
        }
        return advanceSetting;
    }

    public String toString() {
        return "AdvanceSetting{netWorkType=" + this.netWorkType + ", notifyType=" + this.notifyType + ", clearNotification=" + this.clearNotification + ", headUpNotification=" + this.headUpNotification + '}';
    }
}

