/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Parcelable;
import android.os.PowerManager;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSetting;
import com.meizu.cloud.pushsdk.notification.util.NotificationUtils;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import org.json.JSONObject;

public abstract class AbstractPushNotification
implements PushNotification {
    protected static final String TAG = "AbstractPushNotification";
    protected Context context;
    protected PushNotificationBuilder pushNotificationBuilder;
    private NotificationManager notificationManager;
    protected Handler handler;

    protected AbstractPushNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        this.pushNotificationBuilder = pushNotificationBuilder;
        this.context = context;
        this.handler = new Handler(context.getMainLooper());
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    protected void buildExpandableContent(Notification.Builder builder, MessageV3 messageV3) {
    }

    protected void buildContentView(Notification notification, MessageV3 messageV3) {
    }

    protected void buildBigContentView(Notification notification, MessageV3 messageV3) {
    }

    protected void appIconSettingBuilder(Notification.Builder builder, MessageV3 messageV3) {
    }

    protected Notification construtNotificationFinal(MessageV3 messageV3, PendingIntent clickIntent, PendingIntent deleteIntent) {
        Notification.Builder builder = new Notification.Builder(this.context);
        this.basicSettingBuilder(builder, messageV3, clickIntent, deleteIntent);
        this.advanceSettingBuilder(builder, messageV3);
        this.appIconSettingBuilder(builder, messageV3);
        this.buildExpandableContent(builder, messageV3);
        Notification notification = MinSdkChecker.isSupportNotificationBuild() ? builder.build() : builder.getNotification();
        this.buildContentView(notification, messageV3);
        this.buildBigContentView(notification, messageV3);
        return notification;
    }

    protected PendingIntent createClickIntent(MessageV3 messageV3) {
        Intent serviceClickIntent = new Intent();
        serviceClickIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        serviceClickIntent.putExtra("pushMessage", (Parcelable)messageV3);
        serviceClickIntent.putExtra("method", "private");
        String messageReceiver = MzSystemUtils.findReceiver(this.context, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getUploadDataPackageName());
        serviceClickIntent.setClassName(messageV3.getUploadDataPackageName(), messageReceiver);
        serviceClickIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        PendingIntent clickPendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)serviceClickIntent, (int)0x40000000);
        return clickPendingIntent;
    }

    protected PendingIntent createDeleteIntent(MessageV3 messageV3) {
        Intent serviceDeleteIntent = new Intent();
        serviceDeleteIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        serviceDeleteIntent.putExtra("pushMessage", (Parcelable)messageV3);
        serviceDeleteIntent.putExtra("method", "notification_delete");
        String messageReceiver = MzSystemUtils.findReceiver(this.context, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName());
        serviceDeleteIntent.setClassName(messageV3.getPackageName(), messageReceiver);
        serviceDeleteIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        PendingIntent deletePendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)serviceDeleteIntent, (int)0x40000000);
        return deletePendingIntent;
    }

    protected PendingIntent createStateIntent(MessageV3 messageV3) {
        Intent serviceStateIntent = new Intent();
        serviceStateIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        serviceStateIntent.putExtra("notification_state_message", messageV3.getNotificationMessage());
        serviceStateIntent.putExtra("notification_extra_task_id", messageV3.getTaskId());
        serviceStateIntent.putExtra("notification_extra_seq_id", messageV3.getSeqId());
        serviceStateIntent.putExtra("notification_extra_device_id", messageV3.getDeviceId());
        serviceStateIntent.putExtra("notification_extra_push_timestamp", messageV3.getPushTimestamp());
        serviceStateIntent.putExtra("notification_extra_show_package_name", messageV3.getUploadDataPackageName());
        serviceStateIntent.putExtra("method", "notification_state");
        String messageReceiver = MzSystemUtils.findReceiver(this.context, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName());
        serviceStateIntent.setClassName(messageV3.getPackageName(), messageReceiver);
        serviceStateIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        PendingIntent deletePendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)serviceStateIntent, (int)0x40000000);
        return deletePendingIntent;
    }

    protected void basicSettingBuilder(Notification.Builder builder, MessageV3 messageV3, PendingIntent clickIntent, PendingIntent deleteIntent) {
        builder.setContentTitle((CharSequence)messageV3.getTitle());
        builder.setContentText((CharSequence)messageV3.getContent());
        builder.setTicker((CharSequence)messageV3.getContent());
        builder.setAutoCancel(true);
        if (MinSdkChecker.isSupportSendNotification()) {
            builder.setVisibility(1);
        }
        if (MinSdkChecker.isSupportSetDrawableSmallIcon()) {
            Icon smallIcon = this.loadSmallIcon(messageV3.getUploadDataPackageName());
            if (smallIcon != null) {
                builder.setSmallIcon(smallIcon);
            } else {
                DebugLogger.e(TAG, "cannot get " + messageV3.getUploadDataPackageName() + " smallIcon");
                builder.setSmallIcon(RProxy.stat_sys_third_app_notify(this.context));
            }
        } else {
            builder.setSmallIcon(this.pushNotificationBuilder != null && this.pushNotificationBuilder.getmStatusbarIcon() != 0 ? this.pushNotificationBuilder.getmStatusbarIcon() : RProxy.stat_sys_third_app_notify(this.context));
        }
        builder.setContentIntent(clickIntent);
        builder.setDeleteIntent(deleteIntent);
    }

    protected void advanceSettingBuilder(Notification.Builder builder, MessageV3 messageV3) {
        AdvanceSetting advanceSetting = messageV3.getmAdvanceSetting();
        if (advanceSetting != null) {
            if (advanceSetting.getNotifyType() != null) {
                boolean vibrate = advanceSetting.getNotifyType().isVibrate();
                boolean lights = advanceSetting.getNotifyType().isLights();
                boolean sound = advanceSetting.getNotifyType().isSound();
                if (vibrate || lights || sound) {
                    int defaultType = 0;
                    if (vibrate) {
                        defaultType |= 2;
                    }
                    if (lights) {
                        defaultType |= 4;
                    }
                    if (sound) {
                        defaultType |= 1;
                    }
                    DebugLogger.e(TAG, "current notification type is " + defaultType);
                    builder.setDefaults(defaultType);
                }
            }
            builder.setOngoing(!advanceSetting.isClearNotification());
            if (advanceSetting.isHeadUpNotification() && MinSdkChecker.isSupportNotificationBuild()) {
                builder.setPriority(2);
            }
        }
    }

    public Bitmap getBitmapFromURL(String src) {
        ANRequest request = AndroidNetworking.get(src).build();
        ANResponse response = request.executeForBitmap();
        if (response.isSuccess() && response.getResult() != null) {
            DebugLogger.i(TAG, "ANRequest On other Thread down load largeIcon " + src + "image " + (response.getResult() != null ? "success" : "fail"));
            return (Bitmap)response.getResult();
        }
        DebugLogger.i(TAG, "ANRequest On other Thread down load largeIcon " + src + "image fail");
        return null;
    }

    @TargetApi(value=23)
    private Icon loadSmallIcon(String despackageName) {
        Icon smallIcon = null;
        try {
            Resources res = this.context.getPackageManager().getResourcesForApplication(despackageName);
            int titleId = res.getIdentifier("mz_push_notification_small_icon", "drawable", despackageName);
            if (titleId != 0) {
                DebugLogger.i(TAG, "get " + despackageName + " smallIcon success resId " + titleId);
                smallIcon = Icon.createWithResource((String)despackageName, (int)titleId);
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "cannot load smallIcon form package " + despackageName + " Error message " + e.getMessage());
        }
        return smallIcon;
    }

    public Bitmap getAppIcon(Context context, String packageName) {
        Bitmap appIcon;
        try {
            PackageManager packageManager = context.getPackageManager();
            BitmapDrawable bitmapDrawable = (BitmapDrawable)packageManager.getApplicationIcon(packageName);
            appIcon = bitmapDrawable.getBitmap();
        }
        catch (PackageManager.NameNotFoundException e) {
            DebugLogger.i(TAG, "getappicon error " + e.getMessage());
            BitmapDrawable bitmapDrawable = (BitmapDrawable)context.getApplicationInfo().loadIcon(context.getPackageManager());
            appIcon = bitmapDrawable.getBitmap();
        }
        return appIcon;
    }

    protected boolean isOnMainThread() {
        return Thread.currentThread() == this.context.getMainLooper().getThread();
    }

    protected boolean isScreenOnAndUnlock() {
        KeyguardManager keyguardManager;
        PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
        return (Build.VERSION.SDK_INT < 20 ? powerManager.isScreenOn() : powerManager.isInteractive()) && !(keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard")).inKeyguardRestrictedInputMode();
    }

    protected String getFlymeGreenNotificationSetting(MessageV3 messageV3) {
        String flymeNotificationSetting = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)messageV3.getNotificationMessage())) {
                JSONObject jsonObject = new JSONObject(messageV3.getNotificationMessage());
                flymeNotificationSetting = jsonObject.getJSONObject("data").getJSONObject("extra").getString("fns");
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "parse flyme notifification setting error " + e.getMessage());
        }
        DebugLogger.i(TAG, "current notification setting is " + flymeNotificationSetting);
        return flymeNotificationSetting;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void show(MessageV3 messageV3) {
        Notification notification = this.construtNotificationFinal(messageV3, this.createClickIntent(messageV3), this.createDeleteIntent(messageV3));
        NotificationUtils.setInternalApp(notification, true);
        NotificationUtils.setReplyIntent(notification, this.createStateIntent(messageV3));
        notification.extras.putString("android.originalPackageName", messageV3.getUploadDataPackageName());
        notification.extras.putString("android.flymeNotificationSetting", this.getFlymeGreenNotificationSetting(messageV3));
        notification.extras.putString("notification_extra_task_id", messageV3.getTaskId());
        notification.extras.putString("notification_extra_seq_id", messageV3.getSeqId());
        notification.extras.putString("notification_extra_device_id", messageV3.getDeviceId());
        notification.extras.putString("notification_extra_push_timestamp", messageV3.getPushTimestamp());
        int notifyId = (int)System.currentTimeMillis();
        if (messageV3.isDiscard()) {
            if (PushPreferencesUtils.getDiscardNotificationId(this.context, messageV3.getPackageName()) == 0) {
                PushPreferencesUtils.putDiscardNotificationIdByPackageName(this.context, messageV3.getPackageName(), notifyId);
                DebugLogger.i(TAG, "no notification show so put notification id " + notifyId);
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getTaskId())) {
                if (PushPreferencesUtils.getDiscardNotificationTaskId(this.context, messageV3.getPackageName()) == 0) {
                    PushPreferencesUtils.putDiscardNotificationTaskId(this.context, messageV3.getPackageName(), Integer.valueOf(messageV3.getTaskId()));
                } else {
                    if (Integer.valueOf(messageV3.getTaskId()) < PushPreferencesUtils.getDiscardNotificationTaskId(this.context, messageV3.getPackageName())) {
                        DebugLogger.i(TAG, "current package " + messageV3.getPackageName() + " taskid " + messageV3.getTaskId() + " dont show notification");
                        return;
                    }
                    PushPreferencesUtils.putDiscardNotificationTaskId(this.context, messageV3.getPackageName(), Integer.valueOf(messageV3.getTaskId()));
                    notifyId = PushPreferencesUtils.getDiscardNotificationId(this.context, messageV3.getPackageName());
                }
            }
            DebugLogger.i(TAG, "current package " + messageV3.getPackageName() + " notificationId=" + notifyId + " taskId=" + messageV3.getTaskId());
        }
        this.notificationManager.notify(notifyId, notification);
        this.dismissFloatNotification(this.notificationManager, notifyId, messageV3);
    }

    protected void dismissFloatNotification(final NotificationManager notificationManager, final int notificationId, MessageV3 messageV3) {
        AdvanceSetting advanceSetting = messageV3.getmAdvanceSetting();
        if (advanceSetting != null) {
            boolean isFloatNotification = advanceSetting.isHeadUpNotification();
            boolean isClearNotification = advanceSetting.isClearNotification();
            if (isFloatNotification && !isClearNotification) {
                messageV3.getmAdvanceSetting().setHeadUpNotification(false);
                messageV3.getmAdvanceSetting().getNotifyType().setSound(false);
                messageV3.getmAdvanceSetting().getNotifyType().setVibrate(false);
                final Notification notification = this.construtNotificationFinal(messageV3, this.createClickIntent(messageV3), this.createDeleteIntent(messageV3));
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        notificationManager.notify(notificationId, notification);
                    }
                }, 5000L);
            }
        }
    }
}

