/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.internal;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.cache.LruBitmapCache;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.networking.interfaces.BitmapRequestListener;
import com.meizu.cloud.pushsdk.networking.internal.ANRequestQueue;
import java.util.HashMap;
import java.util.LinkedList;

public class ANImageLoader {
    private static final int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
    private static final int cacheSize = maxMemory / 8;
    private int mBatchResponseDelayMs = 100;
    private final ImageCache mCache;
    private final HashMap<String, BatchedImageRequest> mInFlightRequests = new HashMap();
    private final HashMap<String, BatchedImageRequest> mBatchedResponses = new HashMap();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private Runnable mRunnable;
    private static ANImageLoader sInstance;

    public static void initialize() {
        ANImageLoader.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ANImageLoader getInstance() {
        if (sInstance != null) return sInstance;
        Class<ANImageLoader> clazz = ANImageLoader.class;
        synchronized (ANImageLoader.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ANImageLoader(new LruBitmapCache(cacheSize));
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public ANImageLoader(ImageCache imageCache) {
        this.mCache = imageCache;
    }

    public ImageCache getImageCache() {
        return this.mCache;
    }

    public static ImageListener getImageListener(final ImageView view, final int defaultImageResId, final int errorImageResId) {
        return new ImageListener(){

            @Override
            public void onResponse(ImageContainer response, boolean isImmediate) {
                if (response.getBitmap() != null) {
                    view.setImageBitmap(response.getBitmap());
                } else if (defaultImageResId != 0) {
                    view.setImageResource(defaultImageResId);
                }
            }

            @Override
            public void onError(ANError anError) {
                if (errorImageResId != 0) {
                    view.setImageResource(errorImageResId);
                }
            }
        };
    }

    public boolean isCached(String requestUrl, int maxWidth, int maxHeight) {
        return this.isCached(requestUrl, maxWidth, maxHeight, ImageView.ScaleType.CENTER_INSIDE);
    }

    public boolean isCached(String requestUrl, int maxWidth, int maxHeight, ImageView.ScaleType scaleType) {
        this.throwIfNotOnMainThread();
        String cacheKey = ANImageLoader.getCacheKey(requestUrl, maxWidth, maxHeight, scaleType);
        return this.mCache.getBitmap(cacheKey) != null;
    }

    public ImageContainer get(String requestUrl, ImageListener listener) {
        return this.get(requestUrl, listener, 0, 0);
    }

    public ImageContainer get(String requestUrl, ImageListener imageListener, int maxWidth, int maxHeight) {
        return this.get(requestUrl, imageListener, maxWidth, maxHeight, ImageView.ScaleType.CENTER_INSIDE);
    }

    public ImageContainer get(String requestUrl, ImageListener imageListener, int maxWidth, int maxHeight, ImageView.ScaleType scaleType) {
        this.throwIfNotOnMainThread();
        String cacheKey = ANImageLoader.getCacheKey(requestUrl, maxWidth, maxHeight, scaleType);
        Bitmap cachedBitmap = this.mCache.getBitmap(cacheKey);
        if (cachedBitmap != null) {
            ImageContainer container = new ImageContainer(cachedBitmap, requestUrl, null, null);
            imageListener.onResponse(container, true);
            return container;
        }
        ImageContainer imageContainer = new ImageContainer(null, requestUrl, cacheKey, imageListener);
        imageListener.onResponse(imageContainer, true);
        BatchedImageRequest request = this.mInFlightRequests.get(cacheKey);
        if (request != null) {
            request.addContainer(imageContainer);
            return imageContainer;
        }
        ANRequest newRequest = this.makeImageRequest(requestUrl, maxWidth, maxHeight, scaleType, cacheKey);
        this.mInFlightRequests.put(cacheKey, new BatchedImageRequest(newRequest, imageContainer));
        return imageContainer;
    }

    protected ANRequest makeImageRequest(String requestUrl, int maxWidth, int maxHeight, ImageView.ScaleType scaleType, final String cacheKey) {
        ANRequest ANRequest2 = ((ANRequest.GetRequestBuilder)((ANRequest.GetRequestBuilder)((ANRequest.GetRequestBuilder)((ANRequest.GetRequestBuilder)((ANRequest.GetRequestBuilder)AndroidNetworking.get(requestUrl).setTag("ImageRequestTag")).setBitmapMaxHeight(maxHeight)).setBitmapMaxWidth(maxWidth)).setImageScaleType(scaleType)).setBitmapConfig(Bitmap.Config.RGB_565)).build();
        ANRequest2.getAsBitmap(new BitmapRequestListener(){

            @Override
            public void onResponse(Bitmap response) {
                ANImageLoader.this.onGetImageSuccess(cacheKey, response);
            }

            @Override
            public void onError(ANError anError) {
                ANImageLoader.this.onGetImageError(cacheKey, anError);
            }
        });
        return ANRequest2;
    }

    public void setBatchedResponseDelay(int newBatchedResponseDelayMs) {
        this.mBatchResponseDelayMs = newBatchedResponseDelayMs;
    }

    protected void onGetImageSuccess(String cacheKey, Bitmap response) {
        this.mCache.putBitmap(cacheKey, response);
        BatchedImageRequest request = this.mInFlightRequests.remove(cacheKey);
        if (request != null) {
            request.mResponseBitmap = response;
            this.batchResponse(cacheKey, request);
        }
    }

    protected void onGetImageError(String cacheKey, ANError anError) {
        BatchedImageRequest request = this.mInFlightRequests.remove(cacheKey);
        if (request != null) {
            request.setError(anError);
            this.batchResponse(cacheKey, request);
        }
    }

    private void batchResponse(String cacheKey, BatchedImageRequest request) {
        this.mBatchedResponses.put(cacheKey, request);
        if (this.mRunnable == null) {
            this.mRunnable = new Runnable(){

                @Override
                public void run() {
                    for (BatchedImageRequest bir : ANImageLoader.this.mBatchedResponses.values()) {
                        for (ImageContainer container : bir.mContainers) {
                            if (container.mListener == null) continue;
                            if (bir.getError() == null) {
                                container.mBitmap = bir.mResponseBitmap;
                                container.mListener.onResponse(container, false);
                                continue;
                            }
                            container.mListener.onError(bir.getError());
                        }
                    }
                    ANImageLoader.this.mBatchedResponses.clear();
                    ANImageLoader.this.mRunnable = null;
                }
            };
            this.mHandler.postDelayed(this.mRunnable, (long)this.mBatchResponseDelayMs);
        }
    }

    private void throwIfNotOnMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ImageLoader must be invoked from the main thread.");
        }
    }

    private static String getCacheKey(String url, int maxWidth, int maxHeight, ImageView.ScaleType scaleType) {
        return new StringBuilder(url.length() + 12).append("#W").append(maxWidth).append("#H").append(maxHeight).append("#S").append(scaleType.ordinal()).append(url).toString();
    }

    private class BatchedImageRequest {
        private final ANRequest mRequest;
        private Bitmap mResponseBitmap;
        private ANError mANError;
        private final LinkedList<ImageContainer> mContainers = new LinkedList();

        public BatchedImageRequest(ANRequest request, ImageContainer container) {
            this.mRequest = request;
            this.mContainers.add(container);
        }

        public void setError(ANError anError) {
            this.mANError = anError;
        }

        public ANError getError() {
            return this.mANError;
        }

        public void addContainer(ImageContainer container) {
            this.mContainers.add(container);
        }

        public boolean removeContainerAndCancelIfNecessary(ImageContainer container) {
            this.mContainers.remove(container);
            if (this.mContainers.size() == 0) {
                this.mRequest.cancel(true);
                if (this.mRequest.isCanceled()) {
                    this.mRequest.destroy();
                    ANRequestQueue.getInstance().finish(this.mRequest);
                }
                return true;
            }
            return false;
        }
    }

    public class ImageContainer {
        private Bitmap mBitmap;
        private final ImageListener mListener;
        private final String mCacheKey;
        private final String mRequestUrl;

        public ImageContainer(Bitmap bitmap, String requestUrl, String cacheKey, ImageListener listener) {
            this.mBitmap = bitmap;
            this.mRequestUrl = requestUrl;
            this.mCacheKey = cacheKey;
            this.mListener = listener;
        }

        public void cancelRequest() {
            if (this.mListener == null) {
                return;
            }
            BatchedImageRequest request = (BatchedImageRequest)ANImageLoader.this.mInFlightRequests.get(this.mCacheKey);
            if (request != null) {
                boolean canceled = request.removeContainerAndCancelIfNecessary(this);
                if (canceled) {
                    ANImageLoader.this.mInFlightRequests.remove(this.mCacheKey);
                }
            } else {
                request = (BatchedImageRequest)ANImageLoader.this.mBatchedResponses.get(this.mCacheKey);
                if (request != null) {
                    request.removeContainerAndCancelIfNecessary(this);
                    if (request.mContainers.size() == 0) {
                        ANImageLoader.this.mBatchedResponses.remove(this.mCacheKey);
                    }
                }
            }
        }

        public Bitmap getBitmap() {
            return this.mBitmap;
        }

        public String getRequestUrl() {
            return this.mRequestUrl;
        }
    }

    public static interface ImageListener {
        public void onResponse(ImageContainer var1, boolean var2);

        public void onError(ANError var1);
    }

    public static interface ImageCache {
        public Bitmap getBitmap(String var1);

        public void putBitmap(String var1, Bitmap var2);

        public void evictBitmap(String var1);

        public void evictAllBitmap();
    }
}

