/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.notification;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.model.NotificationState;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

public class NotificationStateMessageHandler
extends AbstractMessageHandler<NotificationState> {
    public NotificationStateMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected NotificationState getMessage(Intent intent) {
        String uploadPackageName = intent.getStringExtra("notification_extra_show_package_name");
        String taskId = intent.getStringExtra("notification_extra_task_id");
        String seqId = intent.getStringExtra("notification_extra_seq_id");
        String deviceId = intent.getStringExtra("notification_extra_device_id");
        String pushTimestamp = intent.getStringExtra("notification_extra_push_timestamp");
        String notificationMessage = intent.getStringExtra("notification_state_message");
        DebugLogger.i("AbstractMessageHandler", "current taskId " + taskId + " seqId " + seqId + " deviceId " + deviceId + " packageName " + uploadPackageName);
        MessageV3 messageV3 = MessageV3.parse(this.context().getPackageName(), uploadPackageName, pushTimestamp, deviceId, taskId, seqId, notificationMessage);
        NotificationState notificationState = new NotificationState(messageV3);
        String pkg = intent.getStringExtra("flyme:notification_pkg");
        int id = intent.getIntExtra("flyme:notification_id", 0);
        int state = intent.getIntExtra("flyme:notification_state", 0);
        notificationState.setNotificationId(id);
        notificationState.setNotificationPkg(pkg);
        notificationState.setState(state);
        return notificationState;
    }

    @Override
    protected void unsafeSend(NotificationState message, PushNotification pushNotification) {
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start NotificationStateMessageHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "notification_state".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 32768;
    }

    @Override
    protected void onBeforeEvent(NotificationState message) {
        switch (message.getState()) {
            case -2: {
                DebugLogger.e("AbstractMessageHandler", "notification STATE_NOTIFICATION_SHOW_ACCESS_DENY");
                UxIPUtils.onNoShowPushMessage(this.context(), message.getMessageV3().getUploadDataPackageName(), message.getMessageV3().getDeviceId(), message.getMessageV3().getTaskId(), message.getMessageV3().getSeqId(), message.getMessageV3().getPushTimestamp());
                break;
            }
            case -1: {
                DebugLogger.e("AbstractMessageHandler", "notification STATE_NOTIFICATION_SHOW_INBOX");
                UxIPUtils.onShowInBoxPushMessage(this.context(), message.getMessageV3().getUploadDataPackageName(), message.getMessageV3().getDeviceId(), message.getMessageV3().getTaskId(), message.getMessageV3().getSeqId(), message.getMessageV3().getPushTimestamp());
                break;
            }
            case 0: {
                DebugLogger.e("AbstractMessageHandler", "notification STATE_NOTIFICATION_SHOW_NORMAL");
                break;
            }
            case 1: {
                DebugLogger.e("AbstractMessageHandler", "notification STATE_NOTIFICATION_SHOW_FLOAT");
            }
        }
    }
}

