/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Process;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.reflect.ReflectClass;
import com.meizu.cloud.pushsdk.base.reflect.ReflectResult;
import com.meizu.cloud.pushsdk.handler.impl.model.ControlMessage;
import com.meizu.cloud.pushsdk.pushtracer.QuickTracker;
import com.meizu.cloud.pushsdk.util.UxIPUtils;
import java.util.List;

public class NotificationService
extends IntentService {
    private static final String TAG = "NotificationService";
    private Object newInstance;

    public NotificationService(String name) {
        super(name);
    }

    public NotificationService() {
        super(TAG);
    }

    public void onDestroy() {
        DebugLogger.i(TAG, "NotificationService destroy");
        this.newInstance = null;
        super.onDestroy();
    }

    protected void onHandleIntent(Intent intent) {
        Process.setThreadPriority((int)10);
        try {
            if (intent != null) {
                DebugLogger.i(TAG, "onHandleIntentaction " + intent.getAction());
                String commandType = intent.getStringExtra("command_type");
                DebugLogger.d(TAG, "-- command_type -- " + commandType);
                if (!TextUtils.isEmpty((CharSequence)commandType) && commandType.equals("reflect_receiver")) {
                    String controlMessage = intent.getStringExtra("mz_push_control_message");
                    DebugLogger.i(TAG, "control message is " + controlMessage);
                    if (!TextUtils.isEmpty((CharSequence)controlMessage)) {
                        ControlMessage message = new ControlMessage(controlMessage, null, null);
                        QuickTracker.init((Context)this, message.getStatics().getPushExtra());
                    }
                    this.reflectReceiver(intent);
                }
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "onHandleIntent error " + e.getMessage());
        }
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public String getReceiver(String var1, String var2) {
        if (!TextUtils.isEmpty((CharSequence)var1) && !TextUtils.isEmpty((CharSequence)var2)) {
            String var3 = null;
            Intent var5 = new Intent(var2);
            var5.setPackage(var1);
            PackageManager var6 = this.getPackageManager();
            List var4 = var6.queryBroadcastReceivers(var5, 0);
            if (var4 != null && var4.size() > 0) {
                var3 = ((ResolveInfo)var4.get((int)0)).activityInfo.name;
            }
            return var3;
        }
        return null;
    }

    public void reflectReceiver(Intent intent) {
        String receiver = this.getReceiver(this.getPackageName(), intent.getAction());
        if (TextUtils.isEmpty((CharSequence)receiver)) {
            UxIPUtils.notificationEvent((Context)this, intent, "reflectReceiver sendbroadcast", 2005);
            DebugLogger.i(TAG, " reflectReceiver error: receiver for: " + intent.getAction() + " not found, package: " + this.getPackageName());
            intent.setPackage(this.getPackageName());
            this.sendBroadcast(intent);
        } else {
            try {
                UxIPUtils.notificationEvent((Context)this, intent, "reflectReceiver startservice", 2003);
                intent.setClassName(this.getPackageName(), receiver);
                ReflectResult receiverResult = ReflectClass.forName(receiver).constructor(null).newInstance(null);
                if (receiverResult.ok && receiverResult.value != null) {
                    DebugLogger.i(TAG, "Reflect MzPushReceiver " + receiverResult.ok);
                    ReflectClass.forObject(receiverResult.value).method("onReceive", Context.class, Intent.class).invoke(receiverResult.value, this.getApplicationContext(), intent);
                }
            }
            catch (Exception var11) {
                DebugLogger.i(TAG, "reflect e: " + var11);
                UxIPUtils.notificationEvent((Context)this, intent, var11.getMessage(), 2004);
            }
        }
    }
}

