package com.meizu.cloud.pushsdk.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.BuildExt;
import com.meizu.cloud.pushsdk.base.DeviceUtils;
import com.meizu.cloud.pushsdk.base.SystemProperties;

import java.util.List;

/**
 * Created by liaojinlong on 15-6-11.
 */
public class MzSystemUtils {
    private static final String TAG = "MzSystemUtils";

    private static String getServicesByPackageName(Context context,String packageName) {
        PackageManager packageManager = context.getPackageManager();
        ServiceInfo[] serviceInfos = null;

        try {
            serviceInfos = packageManager.getPackageInfo(packageName, PackageManager.GET_SERVICES).services;
        } catch (PackageManager.NameNotFoundException var4) {
        }

        if(serviceInfos == null) {
            return null;
        } else {
            for(int i = 0; i < serviceInfos.length; ++i) {
                if("com.meizu.cloud.pushsdk.pushservice.MzPushService".equals(serviceInfos[i].name)) {
                    return serviceInfos[i].processName;
                }
            }
            return null;
        }
    }


    /**
     * 获取首次启动MzPushService的包名
     * MzPushService只会由首次启动自身的应用启动,该应用的包名既是各个应用所需要的包名
     * 如果应用中没有一个启动mzPushService,策略选择那个service进行启动
     * @param context
     * */
    public static String getMzPushServicePackageName(Context context){
        String packageName = context.getPackageName();
        try {
            String mzPushserviceProcessName = getServicesByPackageName(context,"com.meizu.cloud");
            if(!TextUtils.isEmpty(mzPushserviceProcessName) && mzPushserviceProcessName.contains("mzservice_v1")){
                packageName = "com.meizu.cloud";
                return packageName;
            }
        } catch (Exception var8) {
            var8.printStackTrace();
        }
        DebugLogger.i("SystemUtils", "startservice package name " + packageName);
        return packageName;
    }


    /**
     * 返回当前程序版本名
     */
    public static String getAppVersionName(Context context,String packageName) {
        String versionName = "";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            versionName = pi.versionName;
            if (versionName == null || versionName.length() <= 0) {
                return "";
            }
        } catch (Exception e) {
            DebugLogger.e("VersionInfo", "Exception message " + e.getMessage());
            return "";
        }
        return versionName;
    }

    /**
     * @param version1
     * @param version2
     * @return boolean
     */
    public static boolean compareVersion(String version1, String version2){
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int idx = 0;
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        while (idx < minLength
                && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0
                && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0) {
            ++idx;
        }
        //如果已经分出大小，则直接返回，如果未分出大小，则再比较位数，有子版本的为大
        diff = (diff != 0) ? diff : versionArray1.length - versionArray2.length;
        return diff >= 0 ? true : false;
    }


    public static String findReceiver(Context paramContext, String action, String packageName){
        if ((TextUtils.isEmpty(action)) || (TextUtils.isEmpty(packageName))){
            return null;
        }
        List localList;
        Intent localIntent = new Intent(action);
        localIntent.setPackage(packageName);
        localList = paramContext.getPackageManager().queryBroadcastReceivers(localIntent, 0);
        if(localList != null && localList.size() > 0){
            return ((ResolveInfo)localList.get(0)).activityInfo.name;
        }
        return null;
    }

    /**
     * get deviceId
     * @param context
     * */
    public static String getDeviceId(Context context){
        String deviceId = DeviceUtils.getDeviceId(context);
        return  deviceId;
    }

    /**
     * 判断是否为魅族设备
     * */
    public static boolean isBrandMeizu(){
        String model = SystemProperties.get("ro.meizu.product.model");
        return (!TextUtils.isEmpty(model)) ||
                "meizu".equalsIgnoreCase(Build.BRAND) ||
                "22c4185e".equalsIgnoreCase(Build.BRAND);
    }

    /**
     * 判断固件是否为国际版
     * */
    public static boolean isInternational() {
        return BuildExt.isInternational().ok ? BuildExt.isInternational().value : false;
    }

    /**
     * 判断固件是否印度版
     * */
    public static boolean isIndiaLocal() {
        String result = SystemProperties.get("ro.meizu.locale.region");
        return "india".equals(result);
    }


    /**
     * 当前应用是否为debug版本
     * @param context
     * */
    public static boolean isApplicationDebug(Context context){
        boolean isDebug = false;
        try {
            ApplicationInfo info = context.getApplicationInfo();
            isDebug = (info.flags & ApplicationInfo.FLAG_DEBUGGABLE) != 0;
        } catch (Exception e){
            e.printStackTrace();
        }
        return isDebug;
    }

    /**
     * 获取应用版本号
     * @param context
     * */
    public static String getAppVersionName(Context context){
        try{
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }catch(PackageManager.NameNotFoundException e){
            return "";
        }
    }
	
	public static boolean compatApi(int apiLevel) {
        return Build.VERSION.SDK_INT >= apiLevel;
    }
	
	public static String getSn() {
        String result = SystemProperties.get("ro.serialno");
        if(!TextUtils.isEmpty(result)) {
            return result;
        }
        return Build.SERIAL;
    }
	
	public static String getProcessName(Context context) {
        int pid = android.os.Process.myPid();
        String processName = "";
        ActivityManager manager = (ActivityManager) context.getApplicationContext().getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningAppProcessInfo process: manager.getRunningAppProcesses()) {
            DebugLogger.i(TAG, "processName " + process.processName);
            if(process.pid == pid) {
                processName = process.processName;
                break;
            }
        }
        return processName;
    }


    /**
     * 根据包名判断应用是否安装
     * @param context
     * @param packageName
     * */
    public static boolean isPackageInstalled(Context context,String packageName) {
        try {
            context.getPackageManager().getPackageInfo(packageName, 0);
            return true;
        } catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }



}
