package com.meizu.cloud.pushsdk.pushtracer.tracker.classic;


import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Executor;
import com.meizu.cloud.pushsdk.pushtracer.event.PushEvent;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Session;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

/**
 * Tracker Event in ThreadPool
 */
public class Tracker extends com.meizu.cloud.pushsdk.pushtracer.tracker.Tracker{
    private final static String TAG = Tracker.class.getSimpleName();
    private static ScheduledExecutorService sessionExecutor;

    /**
     * Constructs a Tracker object.
     *
     * @param builder the base tracker builder
     */
    public Tracker(TrackerBuilder builder) {
        super(builder);

        // Set the thread count
        Executor.setThreadCount(this.threadCount);

        // Start Checking Sessions
        resumeSessionChecking();
    }

    /**
     * Starts a polling session checker to
     * run at a defined interval.
     */
    public void resumeSessionChecking() {
        if (sessionExecutor == null && this.sessionContext) {
            Logger.d(TAG, "Session checking has been resumed.");
            final Session session = this.trackerSession;
            sessionExecutor = Executors.newSingleThreadScheduledExecutor();
            sessionExecutor.scheduleAtFixedRate(new Runnable() {
                @Override
                public void run() {
                    session.checkAndUpdateSession();
                }
            }, this.sessionCheckInterval, this.sessionCheckInterval, this.timeUnit);
        }
    }

    /**
     * Ends the polling session checker.
     */
    public void pauseSessionChecking() {
        if (sessionExecutor != null) {
            Logger.d(TAG, "Session checking has been paused.");
            sessionExecutor.shutdown();
            sessionExecutor = null;
        }
    }


    @Override
    public void track(final PushEvent event) {
        Executor.execute(new Runnable() {
            public void run() {
                Tracker.super.track(event);
            }
        });
    }

    @Override
    public void track(final PushEvent event, final boolean attemptEmit) {
        Executor.execute(new Runnable() {
            public void run() {
                Tracker.super.track(event,attemptEmit);
            }
        });
    }

}
