package com.meizu.cloud.pushsdk.pushtracer.storage;

import com.meizu.cloud.pushsdk.pushtracer.dataload.DataLoad;
import com.meizu.cloud.pushsdk.pushtracer.emitter.EmittableEvents;

/**
 *
 */
public interface Store {
    /**
     * Adds an event to the database or memory.
     *
     * @param dataLoad the payload to be added
     */
    public void add(DataLoad dataLoad);


    /**
     * whether the store is open
     * */
    public boolean isOpen();


    /**
     * Closes the database
     */
    public void close();


    /**
     * Removes an event from the database
     *
     * @param id the row id of the event
     * @return a boolean of success to remove
     */
    public boolean removeEvent(long id);

    /**
     * Empties the database of all events
     *
     * @return a boolean of success to remove
     */
    public boolean removeAllEvents();

    /**
     * Returns amount of events currently
     * in the database.
     *
     * @return the count of events in the
     * database
     */
    public long getSize();


    /**
     * Returns an EmittableEvents object which
     * contains events and eventIds within a
     * defined range of the database.
     *
     * @return an EmittableEvents object containing
     * eventIds and event payloads.
     */
    @SuppressWarnings("unchecked")
    public EmittableEvents getEmittableEvents();
}
