package com.meizu.cloud.pushsdk.pushtracer.event;


import com.meizu.cloud.pushsdk.pushtracer.constant.Parameters;
import com.meizu.cloud.pushsdk.pushtracer.dataload.TrackerDataload;
import com.meizu.cloud.pushsdk.pushtracer.utils.Preconditions;

/**
 * Push event
 */
public class PushEvent extends Event {
    private String eventName;
    private String taskId;
    private String deviceId;
    private String pushsdkVersion;
    private String packageName;
    private String seqId;
    private String messageSeq;
    private String eventCreateTime;

    public static abstract class Builder<T extends Builder<T>> extends Event.Builder<T> {

        private String eventName;
        private String taskId;
        private String deviceId;
        private String pushsdkVersion;
        private String packageName;
        private String seqId;
        private String messageSeq;
        private String eventCreateTime;
        /**
         * @param eventName eventName of the event
         * @return itself
         */
        public T eventName(String eventName) {
            this.eventName = eventName;
            return self();
        }

        /**
         * @param taskId The event taskId
         * @return itself
         */
        public T taskId(String taskId) {
            this.taskId = taskId;
            return self();
        }

        /**
         * @param deviceId
         * @return itself
         */
        public T deviceId(String deviceId) {
            this.deviceId = deviceId;
            return self();
        }

        /**
         * @param pushsdkVersion
         * @return itself
         */
        public T pushsdkVersion(String pushsdkVersion) {
            this.pushsdkVersion = pushsdkVersion;
            return self();
        }

        /**
         * @param packageName
         * @return itself
         */
        public T packageName(String packageName) {
            this.packageName = packageName;
            return self();
        }

        /**
         * @param seqId
         * @return itself
         */
        public T seqId(String seqId) {
            this.seqId = seqId;
            return self();
        }

        /**
         * @param messageSeq
         * @return itself
         */
        public T messageSeq(String messageSeq) {
            this.messageSeq = messageSeq;
            return self();
        }

        /**
         * @param eventCreateTime
         * @return itself
         */
        public T eventCreateTime(String eventCreateTime){
            this.eventCreateTime = eventCreateTime;
            return self();
        }

        public PushEvent build() {
            return new PushEvent(this);
        }
    }

    private static class Builder2 extends Builder<Builder2> {
        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected PushEvent(Builder<?> builder) {
        super(builder);
        // Precondition checks
        //Preconditions.checkNotNull(builder.taskId);
        //Preconditions.checkNotNull(builder.deviceId);
        //Preconditions.checkArgument(!builder.taskId.isEmpty(), "taskId cannot be empty");
        //Preconditions.checkArgument(!builder.deviceId.isEmpty(), "deviceId cannot be empty");

        this.taskId = builder.taskId;
        this.deviceId = builder.deviceId;
        this.eventName = builder.eventName;
        this.pushsdkVersion = builder.pushsdkVersion;
        this.packageName = builder.packageName;
        this.seqId = builder.seqId;
        this.messageSeq = builder.messageSeq;
        this.eventCreateTime = builder.eventCreateTime;
    }

    /**
     * Returns a TrackerPayload which can be stored into
     * the local database.
     *
     * @return the payload to be sent.
     */
    public TrackerDataload getDataLoad() {
        TrackerDataload dataLoad = new TrackerDataload();
        dataLoad.add(Parameters.EVENT_NAME, this.eventName);
        dataLoad.add(Parameters.TASK_ID, this.taskId);
        dataLoad.add(Parameters.DEVICE_ID, this.deviceId);
        dataLoad.add(Parameters.PUSH_SDK_VERSION, this.pushsdkVersion);
        dataLoad.add(Parameters.PACKAGE_NAME,this.packageName);
        dataLoad.add(Parameters.SEQ_ID,this.seqId);
        dataLoad.add(Parameters.MESSAGE_SEQ,this.messageSeq);
        dataLoad.add(Parameters.EVENT_CREATE_TIME,this.eventCreateTime);
        return putDefaultParams(dataLoad);
    }
}
