/*
 * Copyright (c) 2015 Snowplow Analytics Ltd. All rights reserved.
 *
 * This program is licensed to you under the Apache License Version 2.0,
 * and you may not use this file except in compliance with the Apache License Version 2.0.
 * You may obtain a copy of the Apache License Version 2.0 at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Apache License Version 2.0 is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the Apache License Version 2.0 for the specific language governing permissions and limitations there under.
 */

package com.meizu.cloud.pushsdk.pushtracer.constant;

/**
 * Constants which apply to schemas, event types
 * and sending protocols.
 */
public class TrackerConstants {
    public static final String SCHEMA_CONTEXTS = "push_extra_info";
    public static final String GEOLOCATION_SCHEMA = "geolocation";
    public static final String MOBILE_SCHEMA = "mobileinfo";
    public static final String SESSION_SCHEMA = "client_session";

    public static final String POST_CONTENT_TYPE = "application/json; charset=utf-8";

    public static final String SNOWPLOW_SESSION_VARS = "snowplow_session_vars";
}
