package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;

import java.util.concurrent.ScheduledExecutorService;

/**
 * Created by liaojinlong on 17-4-17.
 */
public class UnRegisterStatusStrategy extends Strategy<UnRegisterStatus>{


    public UnRegisterStatusStrategy(Context context, String appId, String appKey, PushAPI pushAPI, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushAPI, executorService);
    }

    public UnRegisterStatusStrategy(Context context,PushAPI pushAPI, ScheduledExecutorService executorService) {
        this(context, null, null, pushAPI, executorService);
    }

    public UnRegisterStatusStrategy(Context context,PushAPI pushAPI, ScheduledExecutorService executorService,boolean enableRPC){
        this(context,pushAPI,executorService);
        this.enableRPC = enableRPC;
    }

    @Override
    protected boolean matchCondition() {
        return !TextUtils.isEmpty(appId) && !TextUtils.isEmpty(appKey);
    }

    @Override
    protected UnRegisterStatus feedBackErrorResponse() {
        UnRegisterStatus registerStatus = new UnRegisterStatus();
        registerStatus.setCode(FEEDBACK_PARAMETER_ERROR_CODE);
        if(TextUtils.isEmpty(appId)){
            registerStatus.setMessage("appId not empty");
        } else if(TextUtils.isEmpty(appKey)){
            registerStatus.setMessage("appKey not empty");
        }
        return registerStatus;
    }

    @Override
    protected Intent sendRpcRequest() {
        Intent intent = new Intent();
        intent.putExtra(APP_ID,appId);
        intent.putExtra(APP_KEY,appKey);
        intent.putExtra(STRATEGY_PACKAGE_NANME,context.getPackageName());
        intent.putExtra(STRATEGY_TYPE,strategyType());
        return intent;
    }

    @Override
    protected UnRegisterStatus netWorkRequest() {
        UnRegisterStatus unRegisterStatus = new UnRegisterStatus();
        String pushId = PushPreferencesUtils.getPushId(context,strategyPackageNanme);
        if(TextUtils.isEmpty(pushId)){
            unRegisterStatus.setCode(SUCCESS_CODE);
            unRegisterStatus.setMessage("already unRegister PushId,dont unRegister frequently");
            unRegisterStatus.setIsUnRegisterSuccess(true);
        } else {
            deviceId = getDeviceId();
            ANResponse<String> anResponse = pushAPI.unRegister(appId,appKey,deviceId);
            if(anResponse.isSuccess()){
                unRegisterStatus = new UnRegisterStatus(anResponse.getResult());
                DebugLogger.e(TAG, "network unRegisterStatus " + unRegisterStatus);
                if(SUCCESS_CODE.equals(unRegisterStatus.getCode())){
                    PushPreferencesUtils.putPushId(context,"",strategyPackageNanme);
                }
            } else {
                ANError error = anResponse.getError();
                if (error.getResponse() != null) {
                    DebugLogger.e(TAG, "status code=" + error.getErrorCode() + " data=" + error.getResponse());
                }
                unRegisterStatus.setCode(String.valueOf(error.getErrorCode()));
                unRegisterStatus.setMessage(error.getErrorBody());
                DebugLogger.e(TAG, "unRegisterStatus " + unRegisterStatus);
            }
        }
        return unRegisterStatus;
    }

    @Override
    protected UnRegisterStatus localResponse() {
        //清楚pushId缓存
        /*PushPreferencesUtils.putPushId(context, "", strategyPackageNanme);
        UnRegisterStatus unRegisterStatus = new UnRegisterStatus();
        unRegisterStatus.setCode(SUCCESS_CODE);
        unRegisterStatus.setMessage("unregister success");
        unRegisterStatus.setIsUnRegisterSuccess(true);
        return unRegisterStatus;*/
        return null;
    }

    @Override
    protected void sendReceiverMessage(UnRegisterStatus message) {
        PlatformMessageSender.sendUnRegisterStatus(context,!TextUtils.isEmpty(strategyPackageNanme) ? strategyPackageNanme : context.getPackageName(), message);
    }

    @Override
    protected int strategyType() {
        return STRATEGY_UNREGISTER;
    }
}
