package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;

import java.util.concurrent.ScheduledExecutorService;

/**
 * Created by liaojinlong on 17-4-17.
 */
public class SubScribeTagStrategy extends Strategy<SubTagsStatus>{
    private String pushId;
    public static final int SUB_TAGS = 0;
    public static final int UNSUB_TAGS = 1;
    public static final int UNSUB_ALL_TAGS = 2;
    public static final int CHECK_SUB_TAGS = 3;

    private int subTagType = 3;
    private String tags;

    public SubScribeTagStrategy(Context context, String appId, String appKey, PushAPI pushAPI, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushAPI, executorService);
    }

    public SubScribeTagStrategy(Context context, String appId, String appKey, String pushId,PushAPI pushAPI, ScheduledExecutorService executorService) {
        this(context, appId, appKey, pushAPI, executorService);
        this.pushId = pushId;
    }

    public SubScribeTagStrategy(Context context,PushAPI pushAPI, ScheduledExecutorService executorService) {
        this(context, null, null,null, pushAPI, executorService);
    }

    public SubScribeTagStrategy(Context context,PushAPI pushAPI, ScheduledExecutorService executorService, boolean enableRPC){
        this(context,pushAPI,executorService);
        this.enableRPC = enableRPC;
    }

    public void setSubTagType(int subTagType){
        this.subTagType = subTagType;
    }

    public void setSubTags(String tags){
        this.tags = tags;
    }

    public void setPushId(String pushId){
        this.pushId = pushId;
    }

    @Override
    protected boolean matchCondition() {
        return !TextUtils.isEmpty(appId) && !TextUtils.isEmpty(appKey) && !TextUtils.isEmpty(pushId);
    }

    @Override
    protected SubTagsStatus feedBackErrorResponse() {
        SubTagsStatus subTagsStatus = new SubTagsStatus();
        subTagsStatus.setCode(FEEDBACK_PARAMETER_ERROR_CODE);
        if(TextUtils.isEmpty(appId)){
            subTagsStatus.setMessage("appId not empty");
        } else if(TextUtils.isEmpty(appKey)){
            subTagsStatus.setMessage("appKey not empty");
        } else if(TextUtils.isEmpty(pushId)){
            subTagsStatus.setMessage("pushId not empty");
        }
        return subTagsStatus;
    }

    @Override
    protected Intent sendRpcRequest() {
        Intent intent = new Intent();
        intent.putExtra(APP_ID,appId);
        intent.putExtra(APP_KEY,appKey);
        intent.putExtra(STRATEGY_PACKAGE_NANME,context.getPackageName());
        intent.putExtra(PUSH_ID,pushId);
        intent.putExtra(STRATEGY_TYPE,strategyType());
        intent.putExtra(STRATEGY_CHILD_TYPE,subTagType);
        intent.putExtra(STRATEGY_PARAMS,tags);
        return intent;
    }

    @Override
    protected SubTagsStatus netWorkRequest() {
        SubTagsStatus subTagsStatus = new SubTagsStatus();
        ANResponse<String> anResponse = null;
        switch (subTagType){
            case SUB_TAGS:
                anResponse = pushAPI.subScribeTags(appId,appKey,pushId,tags);
                break;
            case UNSUB_TAGS:
                anResponse = pushAPI.unSubScribeTags(appId,appKey,pushId,tags);
                break;
            case UNSUB_ALL_TAGS:
                anResponse = pushAPI.unSubAllScribeTags(appId,appKey,pushId);
                break;
            case CHECK_SUB_TAGS:
                anResponse = pushAPI.checkSubScribeTags(appId,appKey,pushId);
                break;
        }
        if(anResponse.isSuccess()){
            subTagsStatus = new SubTagsStatus(anResponse.getResult());
            DebugLogger.e(TAG, "network subTagsStatus " + subTagsStatus);
        } else {
            ANError error = anResponse.getError();
            if (error.getResponse() != null) {
                DebugLogger.e(TAG, "status code=" + error.getErrorCode() + " data=" + error.getResponse());
            }
            subTagsStatus.setCode(String.valueOf(error.getErrorCode()));
            subTagsStatus.setMessage(error.getErrorBody());
            DebugLogger.e(TAG, "subTagsStatus " + subTagsStatus);
        }
        return subTagsStatus;
    }

    @Override
    protected SubTagsStatus localResponse() {
        return null;
    }

    @Override
    protected void sendReceiverMessage(SubTagsStatus message) {
        PlatformMessageSender.sendSubTags(context,!TextUtils.isEmpty(strategyPackageNanme) ? strategyPackageNanme : context.getPackageName(),message);
    }

    @Override
    protected int strategyType() {
        return STRATEGY_SUBTAGS;
    }
}
