package com.meizu.cloud.pushsdk.platform.message;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by liaojinlong on 16-5-20.
 */
public class SubAliasStatus extends BasicPushStatus{
    private String pushId;
    private String alias;

    public SubAliasStatus(String json) {
        super(json);
    }

    public SubAliasStatus() {
        super();
    }

    @Override
    public void parseValueData(JSONObject jsonObject) throws JSONException {
        if(!jsonObject.isNull("pushId")){
            setPushId(jsonObject.getString("pushId"));
        }
        if(!jsonObject.isNull("alias")){
            setAlias(jsonObject.getString("alias"));
        }
    }

    public String getPushId() {
        return pushId;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String toString() {
        return super.toString() + " SubAliasStatus{" +
                "pushId='" + pushId + '\'' +
                ", alias='" + alias + '\'' +
                '}';
    }
}
