package com.meizu.cloud.pushsdk.platform.message;

/**
 * Created by liaojinlong on 17-4-18.
 */
public class StrategyMessage implements Comparable<StrategyMessage>{
    private String appId;
    private String appKey;
    private String packageName;
    private String pushId;
    private int strategyType;
    private int strategyChildType;
    private String params;
    long currentTime;
    private int retryCount = 0;

    public StrategyMessage(String appId, String appKey, String packageName, String pushId, int strategyType, int strategyChildType, String params) {
        this.appId = appId;
        this.appKey = appKey;
        this.packageName = packageName;
        this.pushId = pushId;
        this.strategyType = strategyType;
        this.strategyChildType = strategyChildType;
        this.params = params;
        currentTime = System.currentTimeMillis();
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPushId() {
        return pushId;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    public int getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(int strategyType) {
        this.strategyType = strategyType;
    }

    public int getStrategyChildType() {
        return strategyChildType;
    }

    public void setStrategyChildType(int strategyChildType) {
        this.strategyChildType = strategyChildType;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void countDownRetryCount() {
        this.retryCount = 0;
    }

    public boolean isRetry(){
        boolean flag = true;
        if(++retryCount > 1){
            flag = false;
        }
        return flag;
    }

    @Override
    public int compareTo(StrategyMessage strategyMessage) {
        return (int) (this.currentTime - strategyMessage.currentTime);
    }

    @Override
    public String toString() {
        return "StrategyMessage{" +
                "strategyType=" + strategyType +
                ", packageName='" + packageName + '\'' +
                ", appKey='" + appKey + '\'' +
                ", appId='" + appId + '\'' +
                ", pushId='" + pushId + '\'' +
                ", strategyChildType=" + strategyChildType +
                ", params='" + params + '\'' +
                '}';
    }
}
