package com.meizu.cloud.pushsdk.platform.api;

import android.content.Context;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndStringRequestListener;
import com.meizu.cloud.pushsdk.platform.SignUtils;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;


/**
 * Created by liaojinlong on 16-11-26.
 */
public class PushAPI {
    public static final String TAG = "PushAPI";

    public String API_SERVER = "https://api-push.meizu.com/garcia/api/client/";

    private String REGISTER_URL_PRIX = API_SERVER + "message/registerPush";
    private String UNREGISTER_URL_PRIX = API_SERVER +"message/unRegisterPush";
    private String UNREGISTER_URL_ADVANCE_PRIX = API_SERVER + "advance/unRegisterPush";
    private String CHECK_REGISTER_SWITCH_STATUS_URL_PRIX = API_SERVER +"message/getRegisterSwitch";
    private String CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX = API_SERVER+"message/changeRegisterSwitch";
    private String CHANGE_ALL_SWITCH_STATUS_URL_PRIX = API_SERVER +"message/changeAllSwitch";
    private String SUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/subscribeTags";
    private String UNSUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/unSubscribeTags";
    private String UNSUBSCRIBE_ALL_TAGS_URL_RPIX  = API_SERVER + "message/unSubAllTags";
    private String CHECK_SUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/getSubTags";
    private String SUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/subscribeAlias";
    private String UNSUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/unSubscribeAlias";
    private String CHECK_SUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/getSubAlias";
    private String UPLOAD_LOG_FILE_URL_PRIX = API_SERVER + "log/upload";


    public PushAPI(Context mContext){
        AndroidNetworking.enableLogging();
        if(MzSystemUtils.isInternational() || MzSystemUtils.isIndiaLocal()) {
            API_SERVER = "https://api-push.in.meizu.com/garcia/api/client/";
            REGISTER_URL_PRIX = API_SERVER + "message/registerPush";
            UNREGISTER_URL_PRIX = API_SERVER +"message/unRegisterPush";
            UNREGISTER_URL_ADVANCE_PRIX = API_SERVER + "advance/unRegisterPush";
            CHECK_REGISTER_SWITCH_STATUS_URL_PRIX = API_SERVER +"message/getRegisterSwitch";
            CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX = API_SERVER+"message/changeRegisterSwitch";
            CHANGE_ALL_SWITCH_STATUS_URL_PRIX = API_SERVER +"message/changeAllSwitch";
            SUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/subscribeTags";
            UNSUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/unSubscribeTags";
            UNSUBSCRIBE_ALL_TAGS_URL_RPIX  = API_SERVER + "message/unSubAllTags";
            CHECK_SUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/getSubTags";
            SUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/subscribeAlias";
            UNSUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/unSubscribeAlias";
            CHECK_SUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/getSubAlias";
        }
    }

    /**
     * 设备订阅
     * @param appId
     * @param appKey
     * @param deviceId
     * */
    public void register(String appId,String appKey,String deviceId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "register post map " + requestMap);
        AndroidNetworking.post(REGISTER_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }


    /**
     * 同步接口
     * 设备订阅
     * */
    public ANResponse register(String appId,String appKey,String deviceId){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "register post map " + requestMap);
        return AndroidNetworking.post(REGISTER_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * push平台反注册
     * @param appId
     *            push 平台申请的id
     * @param appKey
     * @param deviceId
     *             设备唯一标志
     * */
    public void unRegister(String appId,String appKey,String deviceId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "unregister post map " + requestMap);
        AndroidNetworking.get(UNREGISTER_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * push平台反注册,同步接口
     * @param appId
     *            push 平台申请的id
     * @param appKey
     * @param deviceId
     *             设备唯一标志
     * */
    public ANResponse unRegister(String appId,String appKey,String deviceId){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "unregister post map " + requestMap);
        return AndroidNetworking.get(UNREGISTER_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 高级反注册接口,用于应用卸载后的反注册
     * @param packageName
     * @param deviceId
     * */
    public void unRegister(String packageName,String deviceId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("packageName", packageName);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, "4a2ca769d79f4856bb3bd982d30de790"));
        DebugLogger.i(TAG, "advance unregister post map " + requestMap);
        AndroidNetworking.post(UNREGISTER_URL_ADVANCE_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 获取push状态开关
     * */
    public void checkPush(String appId,String appKey,String pushId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        AndroidNetworking.get(CHECK_REGISTER_SWITCH_STATUS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 获取push状态开关
     * 同步方法接口
     * */
    public ANResponse checkPush(String appId,String appKey,String pushId){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        return AndroidNetworking.get(CHECK_REGISTER_SWITCH_STATUS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 修改push开关
     * */
    public void switchPush(String appId,String appKey,String pushId,int msgType,boolean switcher,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("msgType", String.valueOf(msgType));
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, CHANGE_ALL_SWITCH_STATUS_URL_PRIX + " switchPush post map " + requestMap);
        AndroidNetworking.post(CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 修改push开关
     * 同步接口
     * */
    public ANResponse switchPush(String appId,String appKey,String pushId,int msgType,boolean switcher){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("msgType", String.valueOf(msgType));
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, CHANGE_ALL_SWITCH_STATUS_URL_PRIX + " switchPush post map " + requestMap);
        return AndroidNetworking.post(CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 同时修改通知栏和透传消息接口
     * */
    public void switchPush(String appId,String appKey,String pushId,boolean switcher,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, CHANGE_ALL_SWITCH_STATUS_URL_PRIX + " switchPush post map " + requestMap);
        AndroidNetworking.post(CHANGE_ALL_SWITCH_STATUS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 同时修改通知栏和透传消息接口
     * 同步接口
     * */
    public ANResponse switchPush(String appId,String appKey,String pushId,boolean switcher){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, CHANGE_ALL_SWITCH_STATUS_URL_PRIX + " switchPush post map " + requestMap);
        return AndroidNetworking.post(CHANGE_ALL_SWITCH_STATUS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 订阅tags
     * */
    public void subScribeTags(String appId,String appKey,String pushId,String args,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        AndroidNetworking.post(SUBSCRIBE_TAGS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 订阅tags
     * 同步方法
     * */
    public ANResponse subScribeTags(String appId,String appKey,String pushId,String args){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        return AndroidNetworking.post(SUBSCRIBE_TAGS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 标签取消订阅
     * */
    public void unSubScribeTags(String appId,String appKey,String pushId,String args,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        AndroidNetworking.post(UNSUBSCRIBE_TAGS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 标签取消订阅
     * 同步方法
     * */
    public ANResponse unSubScribeTags(String appId,String appKey,String pushId,String args){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        return AndroidNetworking.post(UNSUBSCRIBE_TAGS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 取消所有标签订阅
     * */
    public void unSubAllScribeTags(String appId,String appKey,String pushId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeAllTags post map " + requestMap);
        AndroidNetworking.post(UNSUBSCRIBE_ALL_TAGS_URL_RPIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 取消所有标签订阅
     * 同步方法
     * */
    public ANResponse unSubAllScribeTags(String appId,String appKey,String pushId){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeAllTags post map " + requestMap);
        return AndroidNetworking.post(UNSUBSCRIBE_ALL_TAGS_URL_RPIX)
                .addBodyParameter(requestMap)
                .build()
                .executeForString();
    }


    /**
     * 获取标签列表
     * */
    public void checkSubScribeTags(String appId,String appKey,String pushId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        Map<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        AndroidNetworking.get(CHECK_SUBSCRIBE_TAGS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 获取标签列表
     * 同步方法
     * */
    public ANResponse checkSubScribeTags(String appId,String appKey,String pushId){
        Map<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        return AndroidNetworking.get(CHECK_SUBSCRIBE_TAGS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 别名订阅
     * */
    public void subScribeAlias(String appId,String appKey,String pushId,String alias,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("appKey", appKey);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        AndroidNetworking.post(SUBSCRIBE_ALIAS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }


    /**
     * 别名订阅
     * 同步方法
     * */
    public ANResponse subScribeAlias(String appId,String appKey,String pushId,String alias){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("appKey", appKey);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        return AndroidNetworking.post(SUBSCRIBE_ALIAS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 取消别名订阅
     * */
    public void unSubScribeAlias(String appId,String appKey,String pushId,String alias,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        AndroidNetworking.post(UNSUBSCRIBE_ALIAS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }


    /**
     * 取消别名订阅
     * 同步方法
     * */
    public ANResponse unSubScribeAlias(String appId,String appKey,String pushId,String alias){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        return AndroidNetworking.post(UNSUBSCRIBE_ALIAS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .executeForString();
    }

    /**
     * 获取别名
     * */
    public void checkSubScribeAlias(String appId,String appKey,String pushId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        AndroidNetworking.get(CHECK_SUBSCRIBE_ALIAS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 获取别名
     * */
    public ANResponse checkSubScribeAlias(String appId,String appKey,String pushId){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        return AndroidNetworking.get(CHECK_SUBSCRIBE_ALIAS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .executeForString();
    }


    public ANResponse<String> uploadLogFile(String messageId,String deviceId,String errorMsg,File logFile){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("msgId",messageId);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, "4a2ca769d79f4856bb3bd982d30de790"));
        if(!TextUtils.isEmpty(errorMsg)){
            requestMap.put("errorMsg", errorMsg);
        }
        DebugLogger.i(TAG, "uploadLogFile post map " + requestMap);
        ANRequest anRequest = AndroidNetworking.upload(UPLOAD_LOG_FILE_URL_PRIX)
                .addMultipartParameter(requestMap)
                .addMultipartFile("logFile", logFile)
                .build();
        ANResponse<String> response = anRequest.executeForString();
        return response;
    }


}
