package com.meizu.cloud.pushsdk.platform;


import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;


/**
 *
 * <p>
 * pushId 异或加密解密
 */
public class PushIdEncryptUtils {

    private static final String TAG = "PushIdEncryptUtils";
    private static Map<String, String> secretKeyMap = initKeyMap();
    private static final List<String> keyList = new ArrayList<String>(secretKeyMap.keySet());

    /**
     * pushId加密混淆值，只能增加，不能修改或删除，否则历史密文解密失败
     *
     * @return
     */
    private static Map<String, String> initKeyMap() {
        if (isEmpty(secretKeyMap)) {
            synchronized (PushIdEncryptUtils.class) {
                if (isEmpty(secretKeyMap)) {
                    secretKeyMap = new TreeMap<String, String>();
                    secretKeyMap.put("UCI", "v9tC0Myz1MGwXRFy");
                    secretKeyMap.put("G3G", "XAsFqhhaf4gKpmAi");
                    secretKeyMap.put("V5R", "cOqH18NXwBtZVkvz");
                    secretKeyMap.put("0XC", "IgSEKZ3Ea6Pm4woS");
                    secretKeyMap.put("Z9K", "pH6J9DMPNgqQp8m8");
                    secretKeyMap.put("EIM", "K11Rs9HAKRXeNwq8");
                    secretKeyMap.put("SO7", "T8LquL1DvwVcogiU");
                    secretKeyMap.put("DDI", "d02F6ttOtV05MYCQ");
                    secretKeyMap.put("ULY", "ToZZIhAywnUfHShN");
                    secretKeyMap.put("0EV", "r5D5RRwQhfV0AYLb");
                    secretKeyMap.put("N6A", "QAtSBFcXnQoUgHO2");
                    secretKeyMap.put("S5Q", "sDWLrZINnum227am");
                    secretKeyMap.put("RA5", "4Uq3Ruxo1FTBdHQE");
                    secretKeyMap.put("J04", "N5hViUTdLCpN59H0");
                    secretKeyMap.put("B68", "EY3sH1KKtalg5ZaT");
                    secretKeyMap.put("9IW", "q1u0MiuFyim4pCYY");
                    secretKeyMap.put("UU3", "syLnkkd8AqNykVV7");
                    secretKeyMap.put("Z49", "V00FiWu124yE91sH");
                    secretKeyMap.put("BNA", "rPP7AK1VWpKEry3p");
                    secretKeyMap.put("WXG", "om8w5ahkJJgpAH9v");
                }
            }
        }
        return secretKeyMap;
    }


    /**
     * pushId加密
     *
     * @param pushId
     * @return 加密后的字符串
     */
    private static String encryptPushId(String pushId) {
        if(TextUtils.isEmpty(pushId)){
            return "";
        }
        //根据pushId hash取值
        int index = Math.abs(pushId.hashCode()) % secretKeyMap.size();
        String secretkey = keyList.get(index);
        String secretValue = secretKeyMap.get(secretkey);
        String encryption = secretkey;
        try {
            pushId = new String(pushId.getBytes("UTF-8"), "iso-8859-1");
        } catch (Exception e) {
            DebugLogger.e(TAG,"encryptPushId getBytes error "+e.getMessage());
        }
        char[] cipher = new char[pushId.length()];
        for (int i = 0, j = 0; i < pushId.length(); i++, j++) {
            if (j == secretValue.length())
                j = 0;
            cipher[i] = (char) (pushId.charAt(i) ^ secretValue.charAt(j));
            String strCipher = Integer.toHexString(cipher[i]);
            if (strCipher.length() == 1) {
                encryption += "0" + strCipher;
            } else {
                encryption += strCipher;
            }
        }
        return encryption;
    }

    /**
     * pushId解密
     *
     * @param encryption 要解密的字符串
     * @return 解密后的字符串, 不符合加密规则，则原始返回
     */
    public static String decryptPushId(String encryption) {
        if(TextUtils.isEmpty(encryption)){
            return encryption;
        }
        String decoding = encryption;
        try {
            if (encryption.length() > 3) {
                String secretkey = encryption.substring(0, 3);
                if (secretKeyMap.containsKey(secretkey)) {
                    String secretValue = secretKeyMap.get(secretkey);
                    encryption = encryption.substring(3, encryption.length());

                    char[] decryption = new char[encryption.length() / 2];
                    for (int i = 0, j = 0; i < encryption.length() / 2; i++, j++) {
                        if (j == secretValue.length()) {
                            j = 0;
                        }
                        char n = (char) (int) Integer.valueOf(encryption.substring(i * 2, i * 2 + 2), 16);
                        decryption[i] = (char) (n ^ secretValue.charAt(j));
                    }
                    decoding = new String(String.valueOf(decryption).getBytes("iso-8859-1"), "UTF-8");
                }
            }
        } catch (Exception e) {
            DebugLogger.e(TAG,"invalid pushId encryption "+encryption);
        }
        return decoding;
    }


    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return (map == null || map.isEmpty());
    }
}
