package com.meizu.cloud.pushsdk.platform;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.platform.message.BasicPushStatus;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;

import java.util.List;

/**
 * send platform callback message to PushReceiver
 */
public class PlatformMessageSender {
    public static final String TAG = "PlatformMessageSender";
    /**
     * send push status to PushReceiver
     * @param context
     * @param pushSwitchStatus
     * */
    public static void sendPushStatus(Context context,String packageName,final PushSwitchStatus pushSwitchStatus){
        sendPlatformStatus(context, packageName, new OnUpdateIntent() {
            @Override
            public String getMethod() {
                return PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_PUSH_STATUS;
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return pushSwitchStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return PushConstants.EXTRA_APP_PUSH_SWITCH_STATUS;
            }
        });
    }


    /**
     * send register status to PushReceiver
     * @param context
     * @param registerStatus
     *               注册状态
     * */
    public static void sendRegisterStatus(Context context, String packageName, final RegisterStatus registerStatus){
        sendPlatformStatus(context, packageName, new OnUpdateIntent() {
            @Override
            public String getMethod() {
                return PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_REGISTER_STATUS;
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return registerStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return PushConstants.EXTRA_APP_PUSH_REGISTER_STATUS;
            }
        });
    }

    /**
     * send unregister status to pushReceiver
     * */
    public static void sendUnRegisterStatus(Context context,String packageName, final UnRegisterStatus unRegisterStatus){
        sendPlatformStatus(context, packageName, new OnUpdateIntent() {
            @Override
            public String getMethod() {
                return PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_UNREGISTER_STATUS;
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return unRegisterStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return PushConstants.EXTRA_APP_PUSH_UNREGISTER_STATUS;
            }
        });
    }

    public static void sendSubTags(Context context,String packageName, final SubTagsStatus subTagsStatus){
        sendPlatformStatus(context, packageName, new OnUpdateIntent() {
            @Override
            public String getMethod() {
                return PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_SUBTAGS_STATUS;
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return subTagsStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return PushConstants.EXTRA_APP_PUSH_SUBTAGS_STATUS;
            }
        });
    }

    public static void sendSubAlias(Context context, String packageName, final SubAliasStatus subAliasStatus){
        sendPlatformStatus(context, packageName, new OnUpdateIntent() {
            @Override
            public String getMethod() {
                return PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_SUBALIAS_STATUS;
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return subAliasStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return PushConstants.EXTRA_APP_PUSH_SUBALIAS_STATUS;
            }
        });
    }

    /**
     * send platform status to PushReceiver
     * @param context
     * @param onUpdateIntent
     * @param packageName 目标应用包名
     * */
    private static void sendPlatformStatus(Context context,String packageName,OnUpdateIntent onUpdateIntent){
        Intent intent = new Intent();
        intent.addCategory(packageName);
        intent.setPackage(packageName);
        intent.putExtra(PushConstants.MZ_PUSH_MESSAGE_METHOD, onUpdateIntent.getMethod());
        intent.putExtra(onUpdateIntent.getBasicStatusExtra(),onUpdateIntent.getBasicStatus());
        sendMessageFromBroadcast(context, intent, PushConstants.MZ_PUSH_ON_MESSAGE_ACTION, packageName);
        //for start pushservice
        sendMessageFromBroadcast(context, new Intent("com.meizu.cloud.pushservice.action.PUSH_SERVICE_START"), null, packageName);
    }

    /**
     * for get intent extra message
     * */
    private interface OnUpdateIntent{
        /**
         * which method
         * */
        String getMethod();
        /**
         * the basic status sending to PushReceiver
         * */
        BasicPushStatus getBasicStatus();

        String getBasicStatusExtra();
    }

    /**
     * 通知中心开关状态转换
     * @param context
     * @param switchType 开关类型 0:通知栏,1透传消息
     * @param switcher 开关状态
     * */
    public static void switchPushMessageSetting(Context context,int switchType,boolean switcher,String desPackageName){
        String cloudVersionName = MzSystemUtils.getAppVersionName(context, "com.meizu.cloud");
        DebugLogger.i(TAG, context.getPackageName() + " switchPushMessageSetting cloudVersion_name " + cloudVersionName);
        if(!TextUtils.isEmpty(cloudVersionName) && cloudVersionName.startsWith("6")){
            Intent pushServiceIntent = new Intent(PushConstants.MZ_PUSH_ON_MESSAGE_SWITCH_SETTING);
            pushServiceIntent.putExtra(PushConstants.EXTRA_APP_PUSH_SWITCH_SETTING_TYPE,switchType);
            pushServiceIntent.putExtra(PushConstants.EXTRA_APP_PUSH_SWITCH_SETTING_STATUS,switcher);
            pushServiceIntent.putExtra(PushConstants.EXTRA_APP_PUSH_SWITCH_SETTING_PACKAGE_NAME,desPackageName);
            pushServiceIntent.setClassName("com.meizu.cloud", "com.meizu.cloud.pushsdk.pushservice.MzPushService");
            context.startService(pushServiceIntent);
        }
    }

    /**
     * 给桌面系统增加的点击接口，用户打开应用相关页面
     * @param context
     * @param pushMessage
     *                通知栏消息格式
     * @param deviceId
     *                  设置设备唯一标志
     * @param packageName
     * */
    public static void launchStartActivity(Context context,String deviceId,String packageName,String pushMessage){
        MessageV3 messageV3 = MessageV3.parse("",deviceId,"",pushMessage);
        messageV3.setUploadDataPackageName(packageName);
        Intent serviceClickIntent = new Intent();
        serviceClickIntent.setData(Uri.parse("custom://" + System.currentTimeMillis()));
        serviceClickIntent.putExtra(PushConstants.MZ_PUSH_PRIVATE_MESSAGE, messageV3);
        serviceClickIntent.putExtra(PushConstants.MZ_PUSH_MESSAGE_METHOD, PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_PRIVATE);
        serviceClickIntent.setAction(PushConstants.MZ_PUSH_ON_MESSAGE_ACTION);
        if (!TextUtils.isEmpty(packageName)){
            serviceClickIntent.setPackage(packageName);
            serviceClickIntent.setClassName(packageName, "com.meizu.cloud.pushsdk.NotificationService");
        }
        serviceClickIntent.putExtra("command_type", "reflect_receiver");
        DebugLogger.i(TAG,"start notification service "+messageV3);
        try {
            context.startService(serviceClickIntent);
        } catch (Exception e){
            DebugLogger.e(TAG,"launchStartActivity error "+e.getMessage());
        }
    }

    public static void sendMessageFromBroadcast(Context paramContext, Intent paramIntent, String action, String packageName){
        if(!TextUtils.isEmpty(action)){
            paramIntent.setAction(action);
        }
        if(!TextUtils.isEmpty(packageName)){
            paramIntent.setPackage(packageName);
        }
        String name = findReceiver(paramContext,action,packageName);
        if (!TextUtils.isEmpty(name))
            paramIntent.setClassName(packageName, name);
        paramContext.sendBroadcast(paramIntent);
    }

    public static String findReceiver(Context paramContext, String action, String packageName){
        if ((TextUtils.isEmpty(action)) || (TextUtils.isEmpty(packageName))){
            return null;
        }
        Intent localIntent = new Intent(action);
        localIntent.setPackage(packageName);
        List localList = paramContext.getPackageManager().queryBroadcastReceivers(localIntent, 0);
        if(localList != null && localList.size() > 0){
            return ((ResolveInfo)localList.get(0)).activityInfo.name;
        }
        return null;
    }
}
