package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by liaojinlong on 16-6-17.
 */
public class NotifyType implements Parcelable{
    public static final String TAG = "notify_type";
    boolean vibrate;
    boolean lights;
    boolean sound;

    public static final String NOTIFY_TYPE = "nt";
    public static final String VIBRATE = "v";
    public static final String LIGHTS = "l";
    public static final String SOUND = "s";

    public NotifyType(){
        super();
    }

    public NotifyType(Parcel in){
        vibrate = in.readByte() != 0;
        lights = in.readByte() != 0;
        sound = in.readByte() != 0;
    }

    public static final Parcelable.Creator<NotifyType> CREATOR
            = new Parcelable.Creator<NotifyType>() {
        public NotifyType createFromParcel(Parcel in) {
            return new NotifyType(in);
        }

        public NotifyType[] newArray(int size) {
            return new NotifyType[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeByte((byte) (vibrate ? 1 : 0));
        parcel.writeByte((byte) (lights ? 1 : 0));
        parcel.writeByte((byte) (sound ? 1 : 0));
    }

    public boolean isVibrate() {
        return vibrate;
    }

    public void setVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public boolean isLights() {
        return lights;
    }

    public void setLights(boolean lights) {
        this.lights = lights;
    }

    public boolean isSound() {
        return sound;
    }

    public void setSound(boolean sound) {
        this.sound = sound;
    }


    public static NotifyType parse(String setting){
        JSONObject notificationObj = null;
        if(!TextUtils.isEmpty(setting)){
            try {
                notificationObj = new JSONObject(setting);
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return parse(notificationObj);
    }

    public static NotifyType parse(JSONObject notifyTypeObj){
        NotifyType notifyType = new NotifyType();
        if(notifyTypeObj != null){
            try {
                if(!notifyTypeObj.isNull(VIBRATE)){
                    notifyType.setVibrate(notifyTypeObj.getInt(VIBRATE) != 0);
                }
                if(!notifyTypeObj.isNull(LIGHTS)){
                    notifyType.setLights(notifyTypeObj.getInt(LIGHTS) != 0);
                }
                if(!notifyTypeObj.isNull(SOUND)){
                    notifyType.setSound(notifyTypeObj.getInt(SOUND) != 0);
                }
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG,"no such tag "+TAG);
        }

        return notifyType;
    }

    @Override
    public String toString() {
        return "NotifyType{" +
                "vibrate=" + vibrate +
                ", lights=" + lights +
                ", sound=" + sound +
                '}';
    }
}
