package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;


import com.meizu.cloud.pushinternal.DebugLogger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by liaojinlong on 16-11-29.
 * "act_setting":{
 *     "wifi_display": true,
 *      "act_url":""
 * }
 */
public class ActVideoSetting implements Parcelable {

    private boolean wifiDisplay;
    private String actUrl;

    public static final String TAG = "ActVideoSetting";
    public static final String ACT_VIDEO_SETTING = "acts";
    public static final String WIFI_DISPLAY = "wd";
    public static final String ACT_URL = "au";

    public ActVideoSetting(){
        super();
    }

    protected ActVideoSetting(Parcel in) {
        wifiDisplay = in.readByte() != 0;
        actUrl = in.readString();
    }

    public static final Creator<ActVideoSetting> CREATOR = new Creator<ActVideoSetting>() {
        @Override
        public ActVideoSetting createFromParcel(Parcel in) {
            return new ActVideoSetting(in);
        }

        @Override
        public ActVideoSetting[] newArray(int size) {
            return new ActVideoSetting[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeByte((byte) (wifiDisplay ? 1 : 0));
        parcel.writeString(actUrl);
    }

    public boolean isWifiDisplay() {
        return wifiDisplay;
    }

    public void setWifiDisplay(boolean wifiDisplay) {
        this.wifiDisplay = wifiDisplay;
    }

    public String getActUrl() {
        return actUrl;
    }

    public void setActUrl(String actUrl) {
        this.actUrl = actUrl;
    }

    @Override
    public String toString() {
        return "ActVideoSetting{" +
                "wifiDisplay=" + wifiDisplay +
                ", actUrl='" + actUrl + '\'' +
                '}';
    }


    public static ActVideoSetting parse(String setting){
        JSONObject actVideoObj = null;
        if(!TextUtils.isEmpty(setting)){
            try {
                actVideoObj  = new JSONObject(setting);
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return parse(actVideoObj);
    }

    public static ActVideoSetting parse(JSONObject actVideoObj){
        ActVideoSetting actVideoSetting = new ActVideoSetting();
        if(actVideoObj != null){
            try {
                if(!actVideoObj.isNull(WIFI_DISPLAY)){
                    actVideoSetting.setWifiDisplay(actVideoObj.getInt(WIFI_DISPLAY) != 0);
                }
                if(!actVideoObj.isNull(ACT_URL)){
                    actVideoSetting.setActUrl(actVideoObj.getString(ACT_URL));
                }
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG, "no such tag " + TAG);
        }
        return actVideoSetting;
    }


}
