package com.meizu.cloud.pushsdk.notification.flyme;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.RemoteViews;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.AbstractPushNotification;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

/**
 * Standard Notification,disable ExpandableText
 * * general setting
 * * advanceSetting
 * * timeDisplaySetting
 *
 * * AppIcon Setting
 */
public class StandardNotification extends AbstractPushNotification {
    public StandardNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildContentView(Notification notification, MessageV3 messageV3) {
        if (MinSdkChecker.isSupportNotificationBuild()) {
            RemoteViews standardView = new RemoteViews(context.getPackageName(), RProxy.push_expandable_big_image_notification(context));
            standardView.setTextViewText(RProxy.push_big_notification_title(context),messageV3.getTitle());
            standardView.setTextViewText(RProxy.push_big_notification_content(context), messageV3.getContent());
            standardView.setLong(RProxy.push_big_notification_date(context), "setTime", System.currentTimeMillis());
            appLargeIconSetting(standardView,messageV3);
            standardView.setViewVisibility(RProxy.push_big_bigview_defaultView(context), View.GONE);
            standardView.setViewVisibility(RProxy.push_big_bigtext_defaultView(context), View.GONE);
            notification.contentView = standardView;
        }
    }

    /**
     * set app large icon
     * @param standardView
     * @param messageV3
     * */
    protected void appLargeIconSetting(RemoteViews standardView,MessageV3 messageV3){
        if(messageV3.getmAppIconSetting() != null && !isOnMainThread()){
            if(!messageV3.getmAppIconSetting().isDefaultLargeIcon()){
                Bitmap bitmap = getBitmapFromURL(messageV3.getmAppIconSetting().getLargeIconUrl());
                if(bitmap != null){
                    standardView.setImageViewBitmap(RProxy.push_big_notification_icon(context),bitmap);
                } else {
                    standardView.setImageViewBitmap(RProxy.push_big_notification_icon(context), getAppIcon(context, messageV3.getUploadDataPackageName()));
                }
            } else {
                standardView.setImageViewBitmap(RProxy.push_big_notification_icon(context), getAppIcon(context, messageV3.getUploadDataPackageName()));
            }
        } else {
            standardView.setImageViewBitmap(RProxy.push_big_notification_icon(context), getAppIcon(context, messageV3.getUploadDataPackageName()));
        }
    }
}
