package com.meizu.cloud.pushsdk.notification.flyme;

import android.app.Notification;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.RemoteViews;

import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

/**
 * Created by liaojinlong on 16-5-10.
 */
public class ExpandableTextNotification extends StandardNotification {

    public ExpandableTextNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }


    @Override
    protected void buildBigContentView(Notification notification, MessageV3 messageV3) {
        if (MinSdkChecker.isSupportNotificationBuild()) {
            // Inflate and set the layout for the expanded notification view
            RemoteViews expandedView = new RemoteViews(context.getPackageName(), RProxy.push_expandable_big_text_notification(context));
            expandedView.setTextViewText(RProxy.push_big_notification_title(context),messageV3.getTitle());
            expandedView.setLong(RProxy.push_big_notification_date(context), "setTime", System.currentTimeMillis());
            appLargeIconSetting(expandedView, messageV3);
            if(messageV3.getmNotificationStyle() != null && !TextUtils.isEmpty(messageV3.getmNotificationStyle().getExpandableText())){
                expandedView.setViewVisibility(RProxy.push_big_bigtext_defaultView(context), View.VISIBLE);
                expandedView.setTextViewText(RProxy.push_big_bigtext_defaultView(context), messageV3.getmNotificationStyle().getExpandableText());
            }
            notification.bigContentView = expandedView;
        }
    }
}
