package com.meizu.cloud.pushsdk.notification.android;

import android.app.Notification;
import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MessageV4;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.util.FileUtil;
import com.meizu.cloud.pushsdk.notification.util.ZipExtractTask;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Executor;
import com.meizu.cloud.pushsdk.util.Connectivity;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

import java.io.File;

/**
 * Created by liaojinlong on 16-12-1.
 */
public class AndroidVideoNotification extends AndroidStandardNotification {
    public AndroidVideoNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildExpandableContent(Notification.Builder builder, MessageV3 messageV3) {
        if(MinSdkChecker.isSupportNotificationBuild()){
            Notification.BigTextStyle notiStyle = new Notification.BigTextStyle();
            notiStyle.setBigContentTitle(messageV3.getTitle());
            notiStyle.setSummaryText(messageV3.getContent());
            notiStyle.bigText(messageV3.getmNotificationStyle().getExpandableText());
            builder.setStyle(notiStyle);
        }
    }

    @Override
    protected void buildContentView(Notification notification, MessageV3 messageV3) {
        super.buildContentView(notification, messageV3);
        MessageV4 messageV4 = MessageV4.parse(messageV3);
        if(messageV4.getActVideoSetting() != null && !(messageV4.getActVideoSetting().isWifiDisplay() && !Connectivity.isConnectedWifi(context))){

            final String baseActDir = Environment.getExternalStorageDirectory().getAbsolutePath()
                    + "/Android/data/pushSdkAct/"+messageV3.getUploadDataPackageName();
            String actFileName = String.valueOf(System.currentTimeMillis());

            String actUrl = messageV4.getActVideoSetting().getActUrl();
            if(!TextUtils.isEmpty(actUrl)){
                //download act file
                ANRequest request = AndroidNetworking.download(actUrl, baseActDir, actFileName).build();
                ANResponse response = request.executeForDownload();
                if(response.isSuccess()){
                    DebugLogger.i(TAG, "down load " + actUrl + " success");
                    //exact act file dir name must not pure number
                    String actDir = baseActDir+File.separator+"ACT-"+actFileName;
                    String actFile = baseActDir+File.separator+actFileName;
                    ZipExtractTask zipExtractTask = new ZipExtractTask(actFile,actDir);
                    boolean isUzipSuccess = zipExtractTask.doUnzipSync();
                    DebugLogger.i(TAG, "zip file " + isUzipSuccess);
                    if(isUzipSuccess){
                        //将activeView文件夹的路径传进path里
                        Bundle bigBundle = new Bundle();
                        bigBundle.putString("path", actDir);
                        //最后将构建好的bundle丢到flyme.active中
                        Bundle mainBundle = new Bundle();
                        mainBundle.putBundle("big", bigBundle);
                        if(MinSdkChecker.isSupportVideoNotification()){
                            notification.extras.putBundle("flyme.active", mainBundle);
                        }
                    }
                }
            }

            Executor.execute(new Runnable() {
                @Override
                public void run() {
                    File[] files = FileUtil.listFile(baseActDir, String.valueOf(System.currentTimeMillis() - 24 * 60 * 60 * 1000));
                    for (File file : files) {
                        FileUtil.deleteDirectory(file.getPath());
                        DebugLogger.i(TAG, "Delete file directory " + file.getName() + "\n");
                    }
                }
            });
        } else {
            DebugLogger.e(TAG, "only wifi can download act");
        }
    }
}
