package com.meizu.cloud.pushsdk.notification;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.RemoteViews;

import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.flyme.StandardNotification;
import com.meizu.cloud.pushsdk.notification.model.styleenum.InnerStyleLayout;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

/**
 * Created by liaojinlong on 16-5-10.
 */
public class PictureNotification extends StandardNotification {
    private static final String TAG = "PictureNotification";
    public PictureNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildBigContentView(Notification notification, MessageV3 messageV3) {
        if (MinSdkChecker.isSupportNotificationBuild()) {
            Bitmap bannerBitmap = getBitmapFromURL(messageV3.getmNotificationStyle().getBannerImageUrl());
            if(!isOnMainThread() && bannerBitmap != null){
                RemoteViews pureBannerPicView = new RemoteViews(context.getPackageName(), RProxy.push_pure_pic_notification(context));
                pureBannerPicView.setImageViewBitmap(RProxy.push_pure_bigview_banner(context),bannerBitmap);
                pureBannerPicView.setViewVisibility(RProxy.push_pure_bigview_expanded(context), View.GONE);
                pureBannerPicView.setViewVisibility(RProxy.push_pure_bigview_banner(context),View.VISIBLE);
                notification.contentView = pureBannerPicView;

                if(messageV3.getmNotificationStyle().getInnerStyle() == InnerStyleLayout.EXPANDABLE_PIC.getCode()){
                    // Inflate and set the layout for the expanded notification view
                    Bitmap bigBitmap = getBitmapFromURL(messageV3.getmNotificationStyle().getExpandableImageUrl());
                    if(!isOnMainThread() && bigBitmap != null){
                        RemoteViews pureBigPicView = new RemoteViews(context.getPackageName(), RProxy.push_pure_pic_notification(context));
                        pureBigPicView.setImageViewBitmap(RProxy.push_pure_bigview_expanded(context), bigBitmap);
                        pureBigPicView.setViewVisibility(RProxy.push_pure_bigview_expanded(context), View.VISIBLE);
                        pureBigPicView.setViewVisibility(RProxy.push_pure_bigview_banner(context), View.GONE);
                        notification.bigContentView = pureBigPicView;
                    }
                }
            }

        }
    }
}
