package com.meizu.cloud.pushsdk.notification;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by liaojinlong on 15-5-29.
 *@SuppressWarnings("此类不允许增加参数,这是适配V2版本的消息格式，否则会出现序列化问题")
 * 按照设计要求,客户端按照消息类型以决定是否以通知栏的方式展现
 * Json 格式如下：
 * {
 "content": "今日头像下载app狂送100元",
 "title": "今日头条重大利好",
 "isDiscard": true,
 "clickType": "1",
 "extra": {
 "activity": "xxxActivity",
 "url": "www.meizu.com",
 "parameters": {
 "key1": "value1",
 "key2": "value2"
 }
 }
 }
 */
public class MPushMessage implements Serializable{
    private static final String TAG = "MPushMessage";
    /**
     * 此消息任务ID
     * **/
    private String taskId;
    /**
     * 是否必填:true
     * 消息通知类型
     * 0: 代表消息需要在通知栏显示，用户点击后执行后续操作
     * 1: 代表透传消息，需要应用开发者自己决定后续消息的动作
     * */
    private String pushType;

    /**
     * 是否必填:true
     * 接收推送消息的应用包名
     * 此包名应用于push消息应用分发
     * */
    private String packageName;

    /**
     * 通知栏标题字段,用户在通知栏从显示标题
     * */
    private String title;

    /**
     * 通知栏内容字段，应用在通知到中显示内容
     * */
    private String content;

    /**
     * 通知控制器类型,决定通知的展现方式,如震动,闪光灯
     * */
    private String notifyType;

    /**
     * 点击通知栏的效果
     * 1.启动应用主界面,即应用的主界面--notify_launcher_activity
     * 2.启动应用的任意一个界面--notify_activity
     * 3.启动一个web页面--notify_web
     * */
    private String clickType;

    /**
     * 是否忽略该消息
     * */
    private String isDiscard;

    /**
     * 扩展字段,以key-value的方式显示
     *
     * */
    private Map<String,String> extra = new HashMap<>();

    private Map<String,String> params = new HashMap<>();

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public Map<String, String> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }


    public String getClickType() {
        return clickType;
    }

    public void setClickType(String clickType) {
        this.clickType = clickType;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getPushType() {
        return pushType;
    }

    public void setPushType(String pushType) {
        this.pushType = pushType;
    }

    public String getIsDiscard() {
        return isDiscard;
    }

    public void setIsDiscard(String isDiscard) {
        this.isDiscard = isDiscard;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }


    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    @Override
    public String toString() {
        return "MPushMessage{" +
                "taskId='" + taskId + '\'' +
                ", pushType='" + pushType + '\'' +
                ", packageName='" + packageName + '\'' +
                ", title='" + title + '\'' +
                ", content='" + content + '\'' +
                ", notifyType='" + notifyType + '\'' +
                ", clickType='" + clickType + '\'' +
                ", isDiscard='" + isDiscard + '\'' +
                ", extra=" + extra +
                ", params=" + params +
                '}';
    }


    /**
     * 构建消息解析类
     * */
    public static MPushMessage parsePushMessage(String pushType,String pushMessage,String packageName,String taskId){
        MPushMessage mPushMessage = new MPushMessage();
        try {
            mPushMessage.setTaskId(taskId);
            mPushMessage.setPushType(pushType);
            mPushMessage.setPackageName(packageName);
            JSONObject contentPushMessageObj = new JSONObject(pushMessage);
            JSONObject pushMessageObj = contentPushMessageObj.getJSONObject("data");
            if(!pushMessageObj.isNull(PushConstants.CONTENT)){
                mPushMessage.setContent(pushMessageObj.getString(PushConstants.CONTENT));
            }
            if(!pushMessageObj.isNull(PushConstants.IS_DISCARD)){
                mPushMessage.setIsDiscard(pushMessageObj.getString(PushConstants.IS_DISCARD));
            }
            if(!pushMessageObj.isNull(PushConstants.TITLE)){
                mPushMessage.setTitle(pushMessageObj.getString(PushConstants.TITLE));
            }
            if(!pushMessageObj.isNull(PushConstants.CLICK_TYPE)){
                mPushMessage.setClickType(pushMessageObj.getString(PushConstants.CLICK_TYPE));
            }
            if(!pushMessageObj.isNull(PushConstants.EXTRA)){
                JSONObject extraArray = pushMessageObj.getJSONObject(PushConstants.EXTRA);
                if(extraArray != null){
                    if(!extraArray.isNull(PushConstants.PARAMS)){
                        JSONObject parametersJsonObject = null;
                        try {
                            parametersJsonObject = extraArray.getJSONObject(PushConstants.PARAMS);
                        } catch (JSONException e){
                            DebugLogger.i(TAG, "parameter parse error message " + e.getMessage());
                        } finally {
                            if(parametersJsonObject != null){
                                mPushMessage.setParams(getParamsMap(parametersJsonObject));
                            }
                            extraArray.remove(PushConstants.PARAMS);
                        }
                    }
                    Map<String,String> extraMap = getParamsMap(extraArray);
                    mPushMessage.setExtra(extraMap);
                }
            }
        } catch (JSONException e) {
            DebugLogger.i(TAG, "parse push message error " + e.getMessage());
        }
        DebugLogger.i(TAG, " parsePushMessage " + mPushMessage);
        return mPushMessage;
    }

    private static Map<String,String> getParamsMap(JSONObject paramsJsonObject){
        Map<String,String> paramsMap = new HashMap<>();
        try {
            Iterator<String> extraIterator = paramsJsonObject.keys();
            while (extraIterator.hasNext()){
                String key = extraIterator.next();
                String value = paramsJsonObject.getString(key);
                paramsMap.put(key, value);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return paramsMap;
    }
}
